# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openbrokerapi']

package_data = \
{'': ['*']}

install_requires = \
['Flask>=2.1.1,<3.0.0']

extras_require = \
{'docs': ['Sphinx>=4.5.0,<5.0.0', 'sphinx-rtd-theme>=1.0.0,<2.0.0'],
 'gevent': ['gevent>=21.12.0,<22.0.0'],
 'gunicorn': ['gunicorn>=20.1.0,<21.0.0']}

setup_kwargs = {
    'name': 'openbrokerapi',
    'version': '4.3.0',
    'description': 'A python package for the V2 CF Service Broker API and Open Broker API (version 2.13+)',
    'long_description': '|Build Status| |Coverage Status| |Known Vulnerabilities| |PYUP|\n\nOpen Broker API\n===============\n\nA Python package for building Service Brokers supporting API version 2.13+.\n\nFollowing `Open Service Broker\nAPI Spec <https://github.com/openservicebrokerapi/servicebroker/blob/master/spec.md>`__ and `Open\nService Broker API <https://www.openservicebrokerapi.org/>`__\n\nCheck out the documentation_.\n\n.. _documentation: http://openbrokerapi.readthedocs.io/en/latest/\n\nTo find out more about Platform Compatibility for OSBAPI versions, check out\n`Platform Compatibility for OSBAPI <https://github.com/openservicebrokerapi/servicebroker/blob/master/compatibility.md>`__\n\n Not all features are supported with this library due to conflicting features.\n\nInstallation\n------------\n\nThis package is available for Python 3.6+.\n\n.. code:: bash\n\n    pip3 install openbrokerapi\n\n    # including gevent as server\n    pip3 install openbrokerapi[gevent]\n    \n    # recommended production setup\n    pip3 install openbrokerapi[gunicorn]\n\nOr install the development version from github:\n\n.. code:: bash\n\n    pip3 install git+https://github.com/eruvanos/openbrokerapi.git\n\nUsage\n-----\n\nYou can start with a `skeleton project <https://github.com/eruvanos/openbrokerapi-skeleton>`__ or just from scratch.\n\n.. code:: python\n\n    from typing import Union, List\n\n    import openbrokerapi\n    from openbrokerapi import api\n    from openbrokerapi.api import ServiceBroker\n    from openbrokerapi.catalog import ServicePlan\n    from openbrokerapi.service_broker import (\n        Service,\n        ProvisionDetails,\n        ProvisionedServiceSpec,\n        DeprovisionDetails,\n        DeprovisionServiceSpec\n    )\n\n\n    class MyServiceBroker(ServiceBroker):\n        def catalog(self) -> Union[Service, List[Service]]:\n            return Service(\n                id=\'service id\',\n                name=\'service name\',\n                description=\'service description\',\n                bindable=False,\n                plans=[\n                    ServicePlan(\n                        id=\'plan id\',\n                        name=\'plan name\',\n                        description=\'plan description\',\n                    )\n                ]\n            )\n\n        def provision(self,\n                      instance_id: str,\n                      details: ProvisionDetails,\n                      async_allowed: bool,\n                      **kwargs) -> ProvisionedServiceSpec:\n            # Create service instance\n            # ...\n\n            return ProvisionedServiceSpec()\n\n        def deprovision(self,\n                        instance_id: str,\n                        details: DeprovisionDetails,\n                        async_allowed: bool,\n                        **kwargs) -> DeprovisionServiceSpec:\n            # Delete service instance\n            # ...\n\n            return DeprovisionServiceSpec(is_async=False)\n\n    print(\'Start server on 127.0.0.1:5000\')\n    print(\'Check the catalog at:\')\n    print(\'> curl 127.0.0.1:5000/v2/catalog -H "X-Broker-API-Version: 2.14"\')\n    api.serve(MyServiceBroker(), None)\n\n    # Simply start the server\n    # api.serve(ExampleServiceBroker(), api.BrokerCredentials("", ""))\n\n    # or start the server without authentication\n    # api.serve(ExampleServiceBroker(), None)\n\n    # or start the server with multiple authentication\n    # api.serve(ExampleServiceBroker(), [api.BrokerCredentials("", ""), api.BrokerCredentials("", "")])\n\n    # or with multiple service brokers and multiple credentials\n    # api.serve_multiple([ExampleServiceBroker(), ExampleServiceBroker()], [api.BrokerCredentials("", ""), api.BrokerCredentials("", "")])\n\n    # or register blueprint to your own FlaskApp instance\n    # app = Flask(__name__)\n    # logger = basic_config()  # Use root logger with a basic configuration provided by openbrokerapi.log_util\n    # openbroker_bp = api.get_blueprint(ExampleServiceBroker(), api.BrokerCredentials("", ""), logger)\n    # app.register_blueprint(openbroker_bp)\n    # app.run("0.0.0.0")\n\nDeployment\n----------\nThe included :code:`api.serve` function provides a server setup for **local usage only**.\n\nFor productive deployments use the blueprint from :code:`api.get_blueprint` to\nsetup a production ready server like `Waitress <https://docs.pylonsproject.org/projects/waitress/en/latest/>`__\nor other mentioned in `Flask Deployment Docs <http://flask.pocoo.org/docs/dev/deploying/wsgi-standalone/>`__\n\nError Types\n-----------\n\nOpenbrokerapi defines a handful of error types in errors.py for some\ncommon error cases that your service broker may encounter. Raise these\nfrom your ServiceBroker methods where appropriate, and openbrokerapi\nwill do the "right thing" (™), and give Cloud Foundry an appropriate\nstatus code, as per the Service Broker API specification.\n\n\nBugs or Issues\n--------------\n\nPlease report bugs, issues or feature requests to `Github\nIssues`_\n\n\nHow to contribute\n-----------------\n\nYou want to contribute, I really appreciate!\n\nSo let us check how you can contribute:\n\n- Create an issue in the `Github Issues`_. Please provide all information that you think are usefull to solve it.\n- Use the `Github Issues`_ to create a feature request, so we can discuss and find a good interface for that feature.\n- Create a Pull Request. There are some things that will make it easier to review your Pull Request:\n\n    - Use a new branch for every Pull Request\n    - Include just related commits in this branch\n    - Less commits are better, one would be the best (You can squash them.)\n    - Always add tests for your feature, if you are not familiar with writing tests, ask for help.\n    - Hint: To update your fork with the newest changes, follow `these instructions <https://stackoverflow.com/a/7244456/2947505>`_.\n\n[ ~ Dependencies scanned by PyUp.io ~ ]\n\n.. _Github Issues: https://github.com/eruvanos/openbrokerapi/issues\n\n.. |Build Status| image:: https://github.com/eruvanos/openbrokerapi/actions/workflows/python-package.yml/badge.svg\n    :target: https://github.com/eruvanos/openbrokerapi/actions/workflows/python-package.yml\n.. |Coverage Status| image:: https://coveralls.io/repos/github/eruvanos/openbrokerapi/badge.svg?branch=master\n   :target: https://coveralls.io/github/eruvanos/openbrokerapi?branch=main\n.. |Known Vulnerabilities| image:: https://snyk.io/test/github/eruvanos/openbrokerapi/badge.svg\n   :target: https://snyk.io/test/github/eruvanos/openbrokerapi\n.. |PYUP| image:: https://pyup.io/repos/github/eruvanos/openbrokerapi/shield.svg\n     :target: https://pyup.io/repos/github/eruvanos/openbrokerapi/',
    'author': 'Maic Siemering',
    'author_email': 'maic@siemering.tech',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://openbrokerapi.readthedocs.io/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
