
class ProtocolVersion:
    VERSION_1 = 0
    VERSION_2 = 1


class TransmissionMode:
    ACKNOWLEDGED = 0
    UNACKNOWLEDGED = 1


class PduTypeCode:
    FILE_DIRECTIVE = 0
    FILE_DATA = 1


class Direction:
    TOWARD_RECEIVER = 0
    TOWARD_SENDER = 1


class DirectiveCode:
    EOF = 0x04
    FINISHED = 0x05
    ACK = 0x06
    METADATA = 0x07
    NAK = 0x08
    PROMPT = 0x09
    KEEP_ALIVE = 0x0C


class DirectiveSubTypeCode:
    ACK_OTHERS = 0x00
    ACK_FINISHED = 0x01


class ConditionCode:
    NO_ERROR = 0
    POSITIVE_ACK_LIMIT_REACHED = 1
    KEEP_ALIVE_LIMIT_REACHED = 2
    INVALID_TRANSMISSION_MODE = 3
    FILESTORE_REJECTION = 4
    FILE_CHECKSUM_FAILURE = 5
    FILE_SIZE_ERROR = 6
    NAK_LIMIT_REACHED = 7
    INACTIVITY_DETECTED = 8
    INVALID_FILE_STRUCTURE = 9
    CHECK_LIMIT_REACHED = 10
    UNSUPPORTED_CHECKSUM_TYPE = 11
    SUSPEND_REQUEST_RECEIVED = 14
    CANCEL_REQUEST_RECEIVED = 15


class MachineState:
    SEND_METADATA = "SEND_METADATA"
    SEND_FILE = "SEND_FILE"
    SEND_EOF = "SEND_EOF"
    TRANSACTION_CANCELLED = "TRANSACTION_CANCELLED"
    WAIT_FOR_MD = "WAIT_FOR_MD"
    WAIT_FOR_EOF = "WAIT_FOR_EOF"
    GET_MISSING_DATA = "GET_MISSING_DATA"
    SEND_FINISHED = "SEND_FINISHED"
    COMPLETED = "COMPLETED"


class DeliveryCode:
    DATA_COMPLETE = 0
    DATA_INCOMPLETE = 1


class FileStatus:
    DISCARDED_DELIBERATELY = 0
    DISCARDED_FILESTOR_REJECTION = 1
    RETAINED_SUCCESSFULLY = 2
    UNREPORTED = 3


class TransactionStatus:
    UNDEFINED = 0
    ACTIVE = 1
    TERMINATED = 2
    UNRECOGNIZED = 3


class ActionCode:
    CREATE_FILE = 0
    DELETE_FILE = 1
    RENAME_FILE = 2
    APPEND_FILE = 3
    REPLACE_FILE = 4
    CREATE_DIRECTORY = 5
    REMOVE_DIRECTORY = 6
    DENY_FILE = 7  # delete if present
    DENY_DIRECTORY = 8  # remove if present


class TypeFieldCode:
    FILESTORE_REQUEST = 0x00
    FILESTORE_RESPONSE = 0x01
    MESSAGE_TO_USER = 0x02
    FAULT_HANDLER_OVERRIDES = 0x04
    FLOW_LABEL = 0x05
    ENTITY_ID = 0x06


class MessageType:
    PROXY_PUT_REQUEST = 0x00
    PROXY_PUT_CANCEL = 0x09
    ORIGINATING_TRANSACTION_ID = 0x0A
    DIRECTORY_LISTING_REQUEST = 0x10
    DIRECTORY_LISTING_RESPONSE = 0x11
    REMOTE_SUSPEND_REQUEST = 0x30
    REMOTE_SUSPEND_RESPONSE = 0x31
    REMOTE_RESUME_REQUEST = 0x38
    REMOTE_RESUME_RESPONSE = 0x39


class FaultHandlerAction:
    CANCEL = "CANCEL"
    SUSPEND = "SUSPEND"
    IGNORE = "IGNORE"
    ABANDON = "ABANDON"


class ChecksumType:
    MODULAR = 0
    PROXIMITY1 = 1
    CRC32C = 2
    IEEE = 3
    NULL = 15
