"""
collects converter functions from the various ``geometry_converter_XXX`` files in one
common module
"""
from .geometry_converter_hex import (
    convert_geometry_hex1d_to_rect2d,
    convert_geometry_rect2d_back_to_hexe1d,
)

from .geometry_converter_astri import astri_to_2d_array, array_2d_to_astri
from .geometry_converter_chec import chec_to_2d_array, array_2d_to_chec


__all__ = [
    "convert_geometry_hex1d_to_rect2d",
    "convert_geometry_rect2d_back_to_hexe1d",
    "astri_to_2d_array",
    "array_2d_to_astri",
    "chec_to_2d_array",
    "array_2d_to_chec",
]
