# resview-client-python
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.1.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import resview_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import resview_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import resview_client
from pprint import pprint
from resview_client.api import reservations_api
from resview_client.model.http_validation_error import HTTPValidationError
from resview_client.model.reservation_batch_get_request import ReservationBatchGetRequest
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = resview_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with resview_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = reservations_api.ReservationsApi(api_client)
    reservation_batch_get_request = ReservationBatchGetRequest(
        ids=[
            "ids_example",
        ],
    ) # ReservationBatchGetRequest | 

    try:
        # Reservation Get Batch
        api_response = api_instance.reservation_get_batch_api_reservations_get_batch_post(reservation_batch_get_request)
        pprint(api_response)
    except resview_client.ApiException as e:
        print("Exception when calling ReservationsApi->reservation_get_batch_api_reservations_get_batch_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ReservationsApi* | [**reservation_get_batch_api_reservations_get_batch_post**](docs/ReservationsApi.md#reservation_get_batch_api_reservations_get_batch_post) | **POST** /api/reservations:getBatch/ | Reservation Get Batch
*ReservationsApi* | [**reservations_detail_api_reservations_id_get**](docs/ReservationsApi.md#reservations_detail_api_reservations_id_get) | **GET** /api/reservations/{id}/ | Reservations Detail
*ReservationsApi* | [**reservations_list_api_reservations_get**](docs/ReservationsApi.md#reservations_list_api_reservations_get) | **GET** /api/reservations/ | Reservations List


## Documentation For Models

 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [LocationInner](docs/LocationInner.md)
 - [ReservationBatchGetRequest](docs/ReservationBatchGetRequest.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in resview_client.apis and resview_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from resview_client.api.default_api import DefaultApi`
- `from resview_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import resview_client
from resview_client.apis import *
from resview_client.models import *
```

