# generated by datamodel-codegen:
#   filename:  schema/api/operations/pipelines/createAirflowPipeline.json
#   timestamp: 2022-03-04T17:31:08+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Field, constr

from ....operations.pipelines import airflowPipeline
from ....type import basic, entityReference


class CreateAirflowPipelineEntityRequest(BaseModel):
    name: constr(min_length=1, max_length=128) = Field(
        ..., description='Name that identifies this pipeline instance uniquely.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this pipeline.'
    )
    description: Optional[str] = Field(None, description='Description of the pipeline.')
    pipelineType: Optional[airflowPipeline.PipelineType] = None
    pipelineConfig: airflowPipeline.PipelineConfig
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Pipeline.'
    )
    forceDeploy: Optional[bool] = Field(
        'false',
        description='Deploy the pipeline by overwriting existing pipeline with the same name.',
    )
    pausePipeline: Optional[bool] = Field(
        'false',
        description='pause the pipeline from running once the deploy is finished successfully.',
    )
    concurrency: Optional[int] = Field(1, description='Concurrency of the Pipeline.')
    startDate: basic.Date = Field(..., description='Start date of the pipeline.')
    endDate: Optional[basic.Date] = Field(None, description='End Date of the pipeline.')
    pipelineTimezone: Optional[str] = Field(
        'UTC', description='Timezone in which pipeline going to be scheduled.'
    )
    retries: Optional[int] = Field(1, description='Retry pipeline in case of failure')
    retryDelay: Optional[int] = Field(
        300, description='Delay between retries in seconds.'
    )
    pipelineCatchup: Optional[bool] = Field(
        'false', description='pipeline catchup for past executions.'
    )
    scheduleInterval: Optional[str] = Field(
        None, description='Scheduler Interval for the pipeline in cron format.'
    )
    pipelineTimeout: Optional[int] = Field(
        60, description='Timeout for the pipeline in seconds.'
    )
    service: entityReference.EntityReference = Field(
        ...,
        description='Link to the database service where this database is hosted in.',
    )
