import { IPythonDeps } from "./python-deps";
import { IPythonEnv } from "./python-env";
import { IPythonPackaging, PythonPackagingOptions } from "./python-packaging";
import { Component } from "../component";
import { Project } from "../project";
import { Task } from "../task";
import { TomlFile } from "../toml";
/**
 * Manage project dependencies, virtual environments, and packaging through the
 * poetry CLI tool.
 */
export declare class Poetry extends Component implements IPythonDeps, IPythonEnv, IPythonPackaging {
    readonly installTask: Task;
    readonly publishTask: Task;
    /**
     * A task that uploads the package to the Test PyPI repository.
     */
    readonly publishTestTask: Task;
    constructor(project: Project, options: PythonPackagingOptions);
    private synthDependencies;
    private synthDevDependencies;
    /**
     * Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDependency(spec: string): void;
    /**
     * Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDevDependency(spec: string): void;
    /**
     * Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     */
    setupEnvironment(): void;
    /**
     * Installs dependencies (called during post-synthesis).
     */
    installDependencies(): void;
}
/**
 * Poetry-specific options.
 * @see https://python-poetry.org/docs/pyproject/
 */
export interface PoetryPyprojectOptionsWithoutDeps {
    /**
     * Name of the package (required).
     */
    readonly name?: string;
    /**
     * Version of the package (required).
     */
    readonly version?: string;
    /**
     * A short description of the package (required).
     */
    readonly description?: string;
    /**
     * License of this package as an SPDX identifier.
     *
     * If the project is proprietary and does not use a specific license, you
     * can set this value as "Proprietary".
     */
    readonly license?: string;
    /**
     * The authors of the package. Must be in the form "name <email>"
     */
    readonly authors?: string[];
    /**
     * the maintainers of the package. Must be in the form "name <email>"
     */
    readonly maintainers?: string[];
    /**
     * The name of the readme file of the package.
     */
    readonly readme?: string;
    /**
     * A URL to the website of the project.
     */
    readonly homepage?: string;
    /**
     * A URL to the repository of the project.
     */
    readonly repository?: string;
    /**
     * A URL to the documentation of the project.
     */
    readonly documentation?: string;
    /**
     * A list of keywords (max: 5) that the package is related to.
     */
    readonly keywords?: string[];
    /**
     * A list of PyPI trove classifiers that describe the project.
     *
     * @see https://pypi.org/classifiers/
     */
    readonly classifiers?: string[];
    /**
     * A list of packages and modules to include in the final distribution.
     */
    readonly packages?: any[];
    /**
     * A list of patterns that will be included in the final package.
     */
    readonly include?: string[];
    /**
     * A list of patterns that will be excluded in the final package.
     *
     * If a VCS is being used for a package, the exclude field will be seeded with
     * the VCS’ ignore settings (.gitignore for git for example).
     */
    readonly exclude?: string[];
    /**
     * The scripts or executables that will be installed when installing the package.
     */
    readonly scripts?: {
        [key: string]: any;
    };
    /**
     * Source registries from which packages are retrieved.
     */
    readonly source?: any[];
    /**
     * Package extras
     */
    readonly extras?: {
        [key: string]: string[];
    };
    /**
     * Plugins. Must be specified as a table.
     * @see https://toml.io/en/v1.0.0#table
     */
    readonly plugins?: any;
    /**
     * Project custom URLs, in addition to homepage, repository and documentation.
     * E.g. "Bug Tracker"
     */
    readonly urls?: {
        [key: string]: string;
    };
}
/**
 * Poetry-specific options.
 * @see https://python-poetry.org/docs/pyproject/
 */
export interface PoetryPyprojectOptions extends PoetryPyprojectOptionsWithoutDeps {
    /**
     * A list of dependencies for the project.
     *
     * The python version for which your package is compatible is also required.
     *
     * @example { requests: "^2.13.0" }
     */
    readonly dependencies?: {
        [key: string]: any;
    };
    /**
     * A list of development dependencies for the project.
     *
     * @example { requests: "^2.13.0" }
     */
    readonly devDependencies?: {
        [key: string]: any;
    };
}
/**
 * Represents configuration of a pyproject.toml file for a Poetry project.
 *
 * @see https://python-poetry.org/docs/pyproject/
 */
export declare class PoetryPyproject extends Component {
    readonly file: TomlFile;
    constructor(project: Project, options: PoetryPyprojectOptions);
}
