"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const object_file_1 = require("./object-file");
/**
 * Represents a JSON file.
 */
class JsonFile extends object_file_1.ObjectFile {
    constructor(project, filePath, options) {
        super(project, filePath, options);
        this.newline = options.newline ?? true;
        this.supportsComments =
            options.allowComments ??
                (filePath.toLowerCase().endsWith("json5") ||
                    filePath.toLowerCase().endsWith("jsonc"));
        if (!options.obj) {
            throw new Error('"obj" cannot be undefined');
        }
    }
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        const sanitized = JSON.parse(json);
        if (this.marker && !this.supportsComments) {
            sanitized["//"] = this.marker;
        }
        let content = JSON.stringify(sanitized, undefined, 2);
        if (this.marker && this.supportsComments) {
            content = `// ${this.marker}\n${content}`;
        }
        if (this.newline) {
            content += "\n";
        }
        return content;
    }
}
exports.JsonFile = JsonFile;
_a = JSII_RTTI_SYMBOL_1;
JsonFile[_a] = { fqn: "projen.JsonFile", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,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