"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Prettier = exports.TrailingComma = exports.QuoteProps = exports.ProseWrap = exports.HTMLWhitespaceSensitivity = exports.EndOfLine = exports.EmbeddedLanguageFormatting = exports.ArrowParens = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const ignore_file_1 = require("../ignore-file");
const json_1 = require("../json");
const source_code_1 = require("../source-code");
const yaml_1 = require("../yaml");
var ArrowParens;
(function (ArrowParens) {
    /**
     * Always include parens. Example: `(x) => x`
     */
    ArrowParens["ALWAYS"] = "always";
    /**
     * Omit parens when possible. Example: `x => x`
     */
    ArrowParens["AVOID"] = "avoid";
})(ArrowParens = exports.ArrowParens || (exports.ArrowParens = {}));
var EmbeddedLanguageFormatting;
(function (EmbeddedLanguageFormatting) {
    /**
     * Format embedded code if Prettier can automatically identify it.
     */
    EmbeddedLanguageFormatting["AUTO"] = "auto";
    /**
     * Never automatically format embedded code.
     */
    EmbeddedLanguageFormatting["OFF"] = "off";
})(EmbeddedLanguageFormatting = exports.EmbeddedLanguageFormatting || (exports.EmbeddedLanguageFormatting = {}));
var EndOfLine;
(function (EndOfLine) {
    /**
     * Maintain existing (mixed values within one file are normalised by looking
     * at what's used after the first line)
     */
    EndOfLine["AUTO"] = "auto";
    /**
     * Carriage Return character only (\r), used very rarely
     */
    EndOfLine["CR"] = "cr";
    /**
     * Carriage Return + Line Feed characters (\r\n), common on Windows
     */
    EndOfLine["CRLF"] = "crlf";
    /**
     * Line Feed only (\n), common on Linux and macOS as well as inside git repos
     */
    EndOfLine["LF"] = "lf";
})(EndOfLine = exports.EndOfLine || (exports.EndOfLine = {}));
var HTMLWhitespaceSensitivity;
(function (HTMLWhitespaceSensitivity) {
    /**
     * Respect the default value of CSS display property.
     */
    HTMLWhitespaceSensitivity["CSS"] = "css";
    /**
     * Whitespaces are considered insignificant.
     */
    HTMLWhitespaceSensitivity["IGNORE"] = "ignore";
    /**
     * Whitespaces are considered significant.
     */
    HTMLWhitespaceSensitivity["STRICT"] = "strict";
})(HTMLWhitespaceSensitivity = exports.HTMLWhitespaceSensitivity || (exports.HTMLWhitespaceSensitivity = {}));
var ProseWrap;
(function (ProseWrap) {
    /**
     * Wrap prose if it exceeds the print width.
     */
    ProseWrap["ALWAYS"] = "always";
    /**
     * Do not wrap prose.
     */
    ProseWrap["NEVER"] = "never";
    /**
     * Wrap prose as-is.
     */
    ProseWrap["PRESERVE"] = "preserve";
})(ProseWrap = exports.ProseWrap || (exports.ProseWrap = {}));
var QuoteProps;
(function (QuoteProps) {
    /**
     * Only add quotes around object properties where required.
     */
    QuoteProps["ASNEEDED"] = "as-needed";
    /**
     * If at least one property in an object requires quotes, quote all properties.
     */
    QuoteProps["CONSISTENT"] = "consistent";
    /**
     * Respect the input use of quotes in object properties.
     */
    QuoteProps["PRESERVE"] = "preserve";
})(QuoteProps = exports.QuoteProps || (exports.QuoteProps = {}));
var TrailingComma;
(function (TrailingComma) {
    /**
     * Trailing commas wherever possible (including function arguments).
     */
    TrailingComma["ALL"] = "all";
    /**
     * Trailing commas where valid in ES5 (objects, arrays, etc.)
     */
    TrailingComma["ES5"] = "es5";
    /**
     * No trailing commas.
     */
    TrailingComma["NONE"] = "none";
})(TrailingComma = exports.TrailingComma || (exports.TrailingComma = {}));
/**
 * Represents prettier configuration.
 */
class Prettier extends component_1.Component {
    constructor(project, options) {
        super(project);
        this._overrides = options.overrides ?? [];
        if (options.ignoreFile ?? true) {
            this.ignoreFile = new ignore_file_1.IgnoreFile(project, ".prettierignore");
        }
        project.addDevDeps("prettier");
        this.settings = {
            ...options.settings,
        };
        if (options.yaml) {
            new yaml_1.YamlFile(project, ".prettierrc.yml", {
                obj: () => ({ ...this.settings, overrides: [...this._overrides] }),
                marker: true,
            });
        }
        else {
            new json_1.JsonFile(project, ".prettierrc.json", {
                obj: () => ({ ...this.settings, overrides: [...this._overrides] }),
                marker: false,
            });
        }
    }
    static of(project) {
        const isPrettier = (c) => c instanceof Prettier;
        return project.components.find(isPrettier);
    }
    /**
     * Add a prettier override
     * @see https://prettier.io/docs/en/configuration.html#configuration-overrides
     * @param {PrettierOverride} override
     */
    addOverride(override) {
        this._overrides.push(override);
    }
    /**
     * Defines Prettier ignore Patterns
     * these patterns will be added to the file .prettierignore
     *
     * @param pattern filepatterns so exclude from prettier formatting
     */
    addIgnorePattern(pattern) {
        this.ignoreFile?.addPatterns(pattern);
    }
    /**
     *  Returns all Prettier overrides
     */
    get overrides() {
        return [...this._overrides];
    }
    preSynthesize() {
        // Add automatically generated SourceCode files to .prettierignore as they may not be formatted correctly.
        const isSourceCode = (c) => c instanceof source_code_1.SourceCode;
        this.project.components.filter(isSourceCode).forEach((c) => {
            this.addIgnorePattern(c.filePath);
        });
    }
}
exports.Prettier = Prettier;
_a = JSII_RTTI_SYMBOL_1;
Prettier[_a] = { fqn: "projen.javascript.Prettier", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJldHRpZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvamF2YXNjcmlwdC9wcmV0dGllci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDRDQUF5QztBQUN6QyxnREFBNEM7QUFFNUMsa0NBQW1DO0FBRW5DLGdEQUE0QztBQUM1QyxrQ0FBbUM7QUF5TW5DLElBQVksV0FVWDtBQVZELFdBQVksV0FBVztJQUNyQjs7T0FFRztJQUNILGdDQUFpQixDQUFBO0lBRWpCOztPQUVHO0lBQ0gsOEJBQWUsQ0FBQTtBQUNqQixDQUFDLEVBVlcsV0FBVyxHQUFYLG1CQUFXLEtBQVgsbUJBQVcsUUFVdEI7QUFFRCxJQUFZLDBCQVVYO0FBVkQsV0FBWSwwQkFBMEI7SUFDcEM7O09BRUc7SUFDSCwyQ0FBYSxDQUFBO0lBRWI7O09BRUc7SUFDSCx5Q0FBVyxDQUFBO0FBQ2IsQ0FBQyxFQVZXLDBCQUEwQixHQUExQixrQ0FBMEIsS0FBMUIsa0NBQTBCLFFBVXJDO0FBRUQsSUFBWSxTQXFCWDtBQXJCRCxXQUFZLFNBQVM7SUFDbkI7OztPQUdHO0lBQ0gsMEJBQWEsQ0FBQTtJQUViOztPQUVHO0lBQ0gsc0JBQVMsQ0FBQTtJQUVUOztPQUVHO0lBQ0gsMEJBQWEsQ0FBQTtJQUViOztPQUVHO0lBQ0gsc0JBQVMsQ0FBQTtBQUNYLENBQUMsRUFyQlcsU0FBUyxHQUFULGlCQUFTLEtBQVQsaUJBQVMsUUFxQnBCO0FBRUQsSUFBWSx5QkFlWDtBQWZELFdBQVkseUJBQXlCO0lBQ25DOztPQUVHO0lBQ0gsd0NBQVcsQ0FBQTtJQUVYOztPQUVHO0lBQ0gsOENBQWlCLENBQUE7SUFFakI7O09BRUc7SUFDSCw4Q0FBaUIsQ0FBQTtBQUNuQixDQUFDLEVBZlcseUJBQXlCLEdBQXpCLGlDQUF5QixLQUF6QixpQ0FBeUIsUUFlcEM7QUF3QkQsSUFBWSxTQWVYO0FBZkQsV0FBWSxTQUFTO0lBQ25COztPQUVHO0lBQ0gsOEJBQWlCLENBQUE7SUFFakI7O09BRUc7SUFDSCw0QkFBZSxDQUFBO0lBRWY7O09BRUc7SUFDSCxrQ0FBcUIsQ0FBQTtBQUN2QixDQUFDLEVBZlcsU0FBUyxHQUFULGlCQUFTLEtBQVQsaUJBQVMsUUFlcEI7QUFFRCxJQUFZLFVBZVg7QUFmRCxXQUFZLFVBQVU7SUFDcEI7O09BRUc7SUFDSCxvQ0FBc0IsQ0FBQTtJQUV0Qjs7T0FFRztJQUNILHVDQUF5QixDQUFBO0lBRXpCOztPQUVHO0lBQ0gsbUNBQXFCLENBQUE7QUFDdkIsQ0FBQyxFQWZXLFVBQVUsR0FBVixrQkFBVSxLQUFWLGtCQUFVLFFBZXJCO0FBRUQsSUFBWSxhQWVYO0FBZkQsV0FBWSxhQUFhO0lBQ3ZCOztPQUVHO0lBQ0gsNEJBQVcsQ0FBQTtJQUVYOztPQUVHO0lBQ0gsNEJBQVcsQ0FBQTtJQUVYOztPQUVHO0lBQ0gsOEJBQWEsQ0FBQTtBQUNmLENBQUMsRUFmVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQWV4QjtBQUVEOztHQUVHO0FBQ0gsTUFBYSxRQUFTLFNBQVEscUJBQVM7SUFzQnJDLFlBQVksT0FBb0IsRUFBRSxPQUF3QjtRQUN4RCxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFZixJQUFJLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQyxTQUFTLElBQUksRUFBRSxDQUFDO1FBRTFDLElBQUksT0FBTyxDQUFDLFVBQVUsSUFBSSxJQUFJLEVBQUU7WUFDOUIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLHdCQUFVLENBQUMsT0FBTyxFQUFFLGlCQUFpQixDQUFDLENBQUM7U0FDOUQ7UUFFRCxPQUFPLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBRS9CLElBQUksQ0FBQyxRQUFRLEdBQUc7WUFDZCxHQUFHLE9BQU8sQ0FBQyxRQUFRO1NBQ3BCLENBQUM7UUFFRixJQUFJLE9BQU8sQ0FBQyxJQUFJLEVBQUU7WUFDaEIsSUFBSSxlQUFRLENBQUMsT0FBTyxFQUFFLGlCQUFpQixFQUFFO2dCQUN2QyxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQyxFQUFFLEdBQUcsSUFBSSxDQUFDLFFBQVEsRUFBRSxTQUFTLEVBQUUsQ0FBQyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDO2dCQUNsRSxNQUFNLEVBQUUsSUFBSTthQUNiLENBQUMsQ0FBQztTQUNKO2FBQU07WUFDTCxJQUFJLGVBQVEsQ0FBQyxPQUFPLEVBQUUsa0JBQWtCLEVBQUU7Z0JBQ3hDLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDLEVBQUUsR0FBRyxJQUFJLENBQUMsUUFBUSxFQUFFLFNBQVMsRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUM7Z0JBQ2xFLE1BQU0sRUFBRSxLQUFLO2FBQ2QsQ0FBQyxDQUFDO1NBQ0o7SUFDSCxDQUFDO0lBL0NNLE1BQU0sQ0FBQyxFQUFFLENBQUMsT0FBZ0I7UUFDL0IsTUFBTSxVQUFVLEdBQUcsQ0FBQyxDQUFZLEVBQWlCLEVBQUUsQ0FBQyxDQUFDLFlBQVksUUFBUSxDQUFDO1FBQzFFLE9BQU8sT0FBTyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQThDRDs7OztPQUlHO0lBQ0ksV0FBVyxDQUFDLFFBQTBCO1FBQzNDLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7T0FLRztJQUNJLGdCQUFnQixDQUFDLE9BQWU7UUFDckMsSUFBSSxDQUFDLFVBQVUsRUFBRSxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOztPQUVHO0lBQ0gsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sQ0FBQyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRU0sYUFBYTtRQUNsQiwwR0FBMEc7UUFDMUcsTUFBTSxZQUFZLEdBQUcsQ0FBQyxDQUFZLEVBQW1CLEVBQUUsQ0FDckQsQ0FBQyxZQUFZLHdCQUFVLENBQUM7UUFDMUIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFO1lBQ3pELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDcEMsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDOztBQW5GSCw0QkFvRkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50XCI7XG5pbXBvcnQgeyBJZ25vcmVGaWxlIH0gZnJvbSBcIi4uL2lnbm9yZS1maWxlXCI7XG5pbXBvcnQgeyBOb2RlUHJvamVjdCB9IGZyb20gXCIuLi9qYXZhc2NyaXB0XCI7XG5pbXBvcnQgeyBKc29uRmlsZSB9IGZyb20gXCIuLi9qc29uXCI7XG5pbXBvcnQgeyBQcm9qZWN0IH0gZnJvbSBcIi4uL3Byb2plY3RcIjtcbmltcG9ydCB7IFNvdXJjZUNvZGUgfSBmcm9tIFwiLi4vc291cmNlLWNvZGVcIjtcbmltcG9ydCB7IFlhbWxGaWxlIH0gZnJvbSBcIi4uL3lhbWxcIjtcbi8qKlxuICogT3B0aW9ucyBmb3IgUHJldHRpZXJcbiAqXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUHJldHRpZXJPcHRpb25zIHtcbiAgLyoqXG4gICAqIERlZmluZXMgYW4gLnByZXR0aWVySWdub3JlIGZpbGVcbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgaWdub3JlRmlsZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFByZXR0aWVyIHNldHRpbmdzLlxuICAgKiBAZGVmYXVsdCAtIGRlZmF1bHQgc2V0dGluZ3NcbiAgICovXG4gIHJlYWRvbmx5IHNldHRpbmdzPzogUHJldHRpZXJTZXR0aW5ncztcblxuICAvKipcbiAgICogUHJvdmlkZSBhIGxpc3Qgb2YgcGF0dGVybnMgdG8gb3ZlcnJpZGUgcHJldHRpZXIgY29uZmlndXJhdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgW11cbiAgICogQHNlZSBodHRwczovL3ByZXR0aWVyLmlvL2RvY3MvZW4vY29uZmlndXJhdGlvbi5odG1sI2NvbmZpZ3VyYXRpb24tb3ZlcnJpZGVzXG4gICAqL1xuICByZWFkb25seSBvdmVycmlkZXM/OiBQcmV0dGllck92ZXJyaWRlW107XG5cbiAgLyoqXG4gICAqIFdyaXRlIHByZXR0aWVyIGNvbmZpZ3VyYXRpb24gYXMgWUFNTCBpbnN0ZWFkIG9mIEpTT05cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHlhbWw/OiBib29sZWFuO1xufVxuLyoqXG4gKiBPcHRpb25zIHRvIHNldCBpbiBQcmV0dGllciBkaXJlY3RseSBvciB0aHJvdWdoIG92ZXJyaWRlc1xuICpcbiAqIEBzZWUgaHR0cHM6Ly9wcmV0dGllci5pby9kb2NzL2VuL29wdGlvbnMuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIFByZXR0aWVyU2V0dGluZ3Mge1xuICAvKipcbiAgICogSW5jbHVkZSBwYXJlbnRoZXNlcyBhcm91bmQgYSBzb2xlIGFycm93IGZ1bmN0aW9uIHBhcmFtZXRlci5cbiAgICpcbiAgICogQGRlZmF1bHQgQXJyb3dQYXJlbnMuQUxXQVlTXG4gICAqL1xuICByZWFkb25seSBhcnJvd1BhcmVucz86IEFycm93UGFyZW5zO1xuICAvKipcbiAgICogUHV0ID4gb2Ygb3BlbmluZyB0YWdzIG9uIHRoZSBsYXN0IGxpbmUgaW5zdGVhZCBvZiBvbiBhIG5ldyBsaW5lLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgYnJhY2tldFNhbWVMaW5lPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFByaW50IHNwYWNlcyBiZXR3ZWVuIGJyYWNrZXRzLlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBicmFja2V0U3BhY2luZz86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBQcmludCAodG8gc3RkZXJyKSB3aGVyZSBhIGN1cnNvciBhdCB0aGUgZ2l2ZW4gcG9zaXRpb24gd291bGQgbW92ZSB0byBhZnRlciBmb3JtYXR0aW5nLlxuICAgKiBUaGlzIG9wdGlvbiBjYW5ub3QgYmUgdXNlZCB3aXRoIC0tcmFuZ2Utc3RhcnQgYW5kIC0tcmFuZ2UtZW5kLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtMVxuICAgKi9cbiAgcmVhZG9ubHkgY3Vyc29yT2Zmc2V0PzogbnVtYmVyO1xuICAvKipcbiAgICogQ29udHJvbCBob3cgUHJldHRpZXIgZm9ybWF0cyBxdW90ZWQgY29kZSBlbWJlZGRlZCBpbiB0aGUgZmlsZS5cbiAgICpcbiAgICogQGRlZmF1bHQgRW1iZWRkZWRMYW5ndWFnZUZvcm1hdHRpbmcuQVVUT1xuICAgKi9cbiAgcmVhZG9ubHkgZW1iZWRkZWRMYW5ndWFnZUZvcm1hdHRpbmc/OiBFbWJlZGRlZExhbmd1YWdlRm9ybWF0dGluZztcbiAgLyoqXG4gICAqIFdoaWNoIGVuZCBvZiBsaW5lIGNoYXJhY3RlcnMgdG8gYXBwbHkuXG4gICAqXG4gICAqIEBkZWZhdWx0IEVuZE9mTGluZS5MRlxuICAgKi9cbiAgcmVhZG9ubHkgZW5kT2ZMaW5lPzogRW5kT2ZMaW5lO1xuICAvKipcbiAgICogU3BlY2lmeSB0aGUgaW5wdXQgZmlsZXBhdGguIFRoaXMgd2lsbCBiZSB1c2VkIHRvIGRvIHBhcnNlciBpbmZlcmVuY2UuXG4gICAqIEBkZWZhdWx0IG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGZpbGVwYXRoPzogc3RyaW5nO1xuICAvKipcbiAgICogSG93IHRvIGhhbmRsZSB3aGl0ZXNwYWNlcyBpbiBIVE1MLlxuICAgKlxuICAgKiBAZGVmYXVsdCBIVE1MV2hpdGVzcGFjZVNlbnNpdGl2aXR5LkNTU1xuICAgKi9cbiAgcmVhZG9ubHkgaHRtbFdoaXRlc3BhY2VTZW5zaXRpdml0eT86IEhUTUxXaGl0ZXNwYWNlU2Vuc2l0aXZpdHk7XG4gIC8qKlxuICAgKiBJbnNlcnQgQGZvcm1hdCBwcmFnbWEgaW50byBmaWxlJ3MgZmlyc3QgZG9jYmxvY2sgY29tbWVudC5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGluc2VydFByYWdtYT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBVc2Ugc2luZ2xlIHF1b3RlcyBpbiBKU1guXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBqc3hTaW5nbGVRdW90ZT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBXaGljaCBwYXJzZXIgdG8gdXNlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFByZXR0aWVyIGF1dG9tYXRpY2FsbHkgaW5mZXJzIHRoZSBwYXJzZXIgZnJvbSB0aGUgaW5wdXQgZmlsZSBwYXRoLCBzbyB5b3Ugc2hvdWxkbuKAmXQgaGF2ZSB0byBjaGFuZ2UgdGhpcyBzZXR0aW5nLlxuICAgKi9cbiAgcmVhZG9ubHkgcGFyc2VyPzogc3RyaW5nO1xuICAvKipcbiAgICogQWRkIGEgcGx1Z2luLiBNdWx0aXBsZSBwbHVnaW5zIGNhbiBiZSBwYXNzZWQgYXMgc2VwYXJhdGUgYC0tcGx1Z2luYHMuXG4gICAqXG4gICAqIEBkZWZhdWx0IFtdXG4gICAqL1xuICByZWFkb25seSBwbHVnaW5zPzogc3RyaW5nW107XG4gIC8qKlxuICAgKiBDdXN0b20gZGlyZWN0b3J5IHRoYXQgY29udGFpbnMgcHJldHRpZXIgcGx1Z2lucyBpbiBub2RlX21vZHVsZXMgc3ViZGlyZWN0b3J5LlxuICAgKiBPdmVycmlkZXMgZGVmYXVsdCBiZWhhdmlvciB3aGVuIHBsdWdpbnMgYXJlIHNlYXJjaGVkIHJlbGF0aXZlbHkgdG8gdGhlIGxvY2F0aW9uIG9mXG4gICAqIFByZXR0aWVyLlxuICAgKiBNdWx0aXBsZSB2YWx1ZXMgYXJlIGFjY2VwdGVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCBbXVxuICAgKi9cbiAgcmVhZG9ubHkgcGx1Z2luU2VhcmNoRGlycz86IHN0cmluZ1tdO1xuICAvKipcbiAgICogVGhlIGxpbmUgbGVuZ3RoIHdoZXJlIFByZXR0aWVyIHdpbGwgdHJ5IHdyYXAuXG4gICAqXG4gICAqIEBkZWZhdWx0IDgwXG4gICAqL1xuICByZWFkb25seSBwcmludFdpZHRoPzogbnVtYmVyO1xuICAvKipcbiAgICogSG93IHRvIHdyYXAgcHJvc2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IFByb3NlV3JhcC5QUkVTRVJWRVxuICAgKi9cbiAgcmVhZG9ubHkgcHJvc2VXcmFwPzogUHJvc2VXcmFwO1xuICAvKipcbiAgICogQ2hhbmdlIHdoZW4gcHJvcGVydGllcyBpbiBvYmplY3RzIGFyZSBxdW90ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IFF1b3RlUHJvcHMuQVNORUVERURcbiAgICovXG4gIHJlYWRvbmx5IHF1b3RlUHJvcHM/OiBRdW90ZVByb3BzO1xuICAvKipcbiAgICogRm9ybWF0IGNvZGUgZW5kaW5nIGF0IGEgZ2l2ZW4gY2hhcmFjdGVyIG9mZnNldCAoZXhjbHVzaXZlKS5cbiAgICogVGhlIHJhbmdlIHdpbGwgZXh0ZW5kIGZvcndhcmRzIHRvIHRoZSBlbmQgb2YgdGhlIHNlbGVjdGVkIHN0YXRlbWVudC5cbiAgICogVGhpcyBvcHRpb24gY2Fubm90IGJlIHVzZWQgd2l0aCAtLWN1cnNvci1vZmZzZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IG51bGxcbiAgICovXG4gIHJlYWRvbmx5IHJhbmdlRW5kPzogbnVtYmVyO1xuICAvKipcbiAgICogRm9ybWF0IGNvZGUgc3RhcnRpbmcgYXQgYSBnaXZlbiBjaGFyYWN0ZXIgb2Zmc2V0LlxuICAgKiBUaGUgcmFuZ2Ugd2lsbCBleHRlbmQgYmFja3dhcmRzIHRvIHRoZSBzdGFydCBvZiB0aGUgZmlyc3QgbGluZSBjb250YWluaW5nIHRoZSBzZWxlY3RlZFxuICAgKiBzdGF0ZW1lbnQuXG4gICAqIFRoaXMgb3B0aW9uIGNhbm5vdCBiZSB1c2VkIHdpdGggLS1jdXJzb3Itb2Zmc2V0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAwXG4gICAqL1xuICByZWFkb25seSByYW5nZVN0YXJ0PzogbnVtYmVyO1xuICAvKipcbiAgICogUmVxdWlyZSBlaXRoZXIgJ0BwcmV0dGllcicgb3IgJ0Bmb3JtYXQnIHRvIGJlIHByZXNlbnQgaW4gdGhlIGZpbGUncyBmaXJzdCBkb2NibG9ja1xuICAgKiBjb21tZW50XG4gICAqIGluIG9yZGVyIGZvciBpdCB0byBiZSBmb3JtYXR0ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSByZXF1aXJlUHJhZ21hPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFByaW50IHNlbWljb2xvbnMuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IHNlbWk/OiBib29sZWFuO1xuICAvKipcbiAgICogVXNlIHNpbmdsZSBxdW90ZXMgaW5zdGVhZCBvZiBkb3VibGUgcXVvdGVzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgc2luZ2xlUXVvdGU/OiBib29sZWFuO1xuICAvKipcbiAgICogTnVtYmVyIG9mIHNwYWNlcyBwZXIgaW5kZW50YXRpb24gbGV2ZWwuXG4gICAqXG4gICAqIEBkZWZhdWx0IDJcbiAgICovXG4gIHJlYWRvbmx5IHRhYldpZHRoPzogbnVtYmVyO1xuICAvKipcbiAgICogUHJpbnQgdHJhaWxpbmcgY29tbWFzIHdoZXJldmVyIHBvc3NpYmxlIHdoZW4gbXVsdGktbGluZS5cbiAgICpcbiAgICogQGRlZmF1bHQgVHJhaWxpbmdDb21tYS5FUzVcbiAgICovXG4gIHJlYWRvbmx5IHRyYWlsaW5nQ29tbWE/OiBUcmFpbGluZ0NvbW1hO1xuICAvKipcbiAgICogSW5kZW50IHdpdGggdGFicyBpbnN0ZWFkIG9mIHNwYWNlcy5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHVzZVRhYnM/OiBib29sZWFuO1xuICAvKipcbiAgICogSW5kZW50IHNjcmlwdCBhbmQgc3R5bGUgdGFncyBpbiBWdWUgZmlsZXMuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSB2dWVJbmRlbnRTY3JpcHRBbmRTdHlsZT86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBlbnVtIEFycm93UGFyZW5zIHtcbiAgLyoqXG4gICAqIEFsd2F5cyBpbmNsdWRlIHBhcmVucy4gRXhhbXBsZTogYCh4KSA9PiB4YFxuICAgKi9cbiAgQUxXQVlTID0gXCJhbHdheXNcIixcblxuICAvKipcbiAgICogT21pdCBwYXJlbnMgd2hlbiBwb3NzaWJsZS4gRXhhbXBsZTogYHggPT4geGBcbiAgICovXG4gIEFWT0lEID0gXCJhdm9pZFwiLFxufVxuXG5leHBvcnQgZW51bSBFbWJlZGRlZExhbmd1YWdlRm9ybWF0dGluZyB7XG4gIC8qKlxuICAgKiBGb3JtYXQgZW1iZWRkZWQgY29kZSBpZiBQcmV0dGllciBjYW4gYXV0b21hdGljYWxseSBpZGVudGlmeSBpdC5cbiAgICovXG4gIEFVVE8gPSBcImF1dG9cIixcblxuICAvKipcbiAgICogTmV2ZXIgYXV0b21hdGljYWxseSBmb3JtYXQgZW1iZWRkZWQgY29kZS5cbiAgICovXG4gIE9GRiA9IFwib2ZmXCIsXG59XG5cbmV4cG9ydCBlbnVtIEVuZE9mTGluZSB7XG4gIC8qKlxuICAgKiBNYWludGFpbiBleGlzdGluZyAobWl4ZWQgdmFsdWVzIHdpdGhpbiBvbmUgZmlsZSBhcmUgbm9ybWFsaXNlZCBieSBsb29raW5nXG4gICAqIGF0IHdoYXQncyB1c2VkIGFmdGVyIHRoZSBmaXJzdCBsaW5lKVxuICAgKi9cbiAgQVVUTyA9IFwiYXV0b1wiLFxuXG4gIC8qKlxuICAgKiBDYXJyaWFnZSBSZXR1cm4gY2hhcmFjdGVyIG9ubHkgKFxcciksIHVzZWQgdmVyeSByYXJlbHlcbiAgICovXG4gIENSID0gXCJjclwiLFxuXG4gIC8qKlxuICAgKiBDYXJyaWFnZSBSZXR1cm4gKyBMaW5lIEZlZWQgY2hhcmFjdGVycyAoXFxyXFxuKSwgY29tbW9uIG9uIFdpbmRvd3NcbiAgICovXG4gIENSTEYgPSBcImNybGZcIixcblxuICAvKipcbiAgICogTGluZSBGZWVkIG9ubHkgKFxcbiksIGNvbW1vbiBvbiBMaW51eCBhbmQgbWFjT1MgYXMgd2VsbCBhcyBpbnNpZGUgZ2l0IHJlcG9zXG4gICAqL1xuICBMRiA9IFwibGZcIixcbn1cblxuZXhwb3J0IGVudW0gSFRNTFdoaXRlc3BhY2VTZW5zaXRpdml0eSB7XG4gIC8qKlxuICAgKiBSZXNwZWN0IHRoZSBkZWZhdWx0IHZhbHVlIG9mIENTUyBkaXNwbGF5IHByb3BlcnR5LlxuICAgKi9cbiAgQ1NTID0gXCJjc3NcIixcblxuICAvKipcbiAgICogV2hpdGVzcGFjZXMgYXJlIGNvbnNpZGVyZWQgaW5zaWduaWZpY2FudC5cbiAgICovXG4gIElHTk9SRSA9IFwiaWdub3JlXCIsXG5cbiAgLyoqXG4gICAqIFdoaXRlc3BhY2VzIGFyZSBjb25zaWRlcmVkIHNpZ25pZmljYW50LlxuICAgKi9cbiAgU1RSSUNUID0gXCJzdHJpY3RcIixcbn1cblxuZXhwb3J0IGludGVyZmFjZSBQcmV0dGllck92ZXJyaWRlIHtcbiAgLyoqXG4gICAqIEV4Y2x1ZGUgdGhlc2UgZmlsZXMgZnJvbSB0aGlzIG92ZXJyaWRlLlxuICAgKi9cbiAgcmVhZG9ubHkgZXhjbHVkZUZpbGVzPzogRmlsZXM7XG4gIC8qKlxuICAgKiBJbmNsdWRlIHRoZXNlIGZpbGVzIGluIHRoaXMgb3ZlcnJpZGUuXG4gICAqL1xuICByZWFkb25seSBmaWxlczogRmlsZXM7XG4gIC8qKlxuICAgKiBUaGUgb3B0aW9ucyB0byBhcHBseSBmb3IgdGhpcyBvdmVycmlkZS5cbiAgICovXG4gIHJlYWRvbmx5IG9wdGlvbnM6IFByZXR0aWVyU2V0dGluZ3M7XG59XG5cbi8qKlxuICogRXhjbHVkZSB0aGVzZSBmaWxlcyBmcm9tIHRoaXMgb3ZlcnJpZGUuXG4gKlxuICogSW5jbHVkZSB0aGVzZSBmaWxlcyBpbiB0aGlzIG92ZXJyaWRlLlxuICovXG5leHBvcnQgdHlwZSBGaWxlcyA9IHN0cmluZ1tdIHwgc3RyaW5nO1xuXG5leHBvcnQgZW51bSBQcm9zZVdyYXAge1xuICAvKipcbiAgICogV3JhcCBwcm9zZSBpZiBpdCBleGNlZWRzIHRoZSBwcmludCB3aWR0aC5cbiAgICovXG4gIEFMV0FZUyA9IFwiYWx3YXlzXCIsXG5cbiAgLyoqXG4gICAqIERvIG5vdCB3cmFwIHByb3NlLlxuICAgKi9cbiAgTkVWRVIgPSBcIm5ldmVyXCIsXG5cbiAgLyoqXG4gICAqIFdyYXAgcHJvc2UgYXMtaXMuXG4gICAqL1xuICBQUkVTRVJWRSA9IFwicHJlc2VydmVcIixcbn1cblxuZXhwb3J0IGVudW0gUXVvdGVQcm9wcyB7XG4gIC8qKlxuICAgKiBPbmx5IGFkZCBxdW90ZXMgYXJvdW5kIG9iamVjdCBwcm9wZXJ0aWVzIHdoZXJlIHJlcXVpcmVkLlxuICAgKi9cbiAgQVNORUVERUQgPSBcImFzLW5lZWRlZFwiLFxuXG4gIC8qKlxuICAgKiBJZiBhdCBsZWFzdCBvbmUgcHJvcGVydHkgaW4gYW4gb2JqZWN0IHJlcXVpcmVzIHF1b3RlcywgcXVvdGUgYWxsIHByb3BlcnRpZXMuXG4gICAqL1xuICBDT05TSVNURU5UID0gXCJjb25zaXN0ZW50XCIsXG5cbiAgLyoqXG4gICAqIFJlc3BlY3QgdGhlIGlucHV0IHVzZSBvZiBxdW90ZXMgaW4gb2JqZWN0IHByb3BlcnRpZXMuXG4gICAqL1xuICBQUkVTRVJWRSA9IFwicHJlc2VydmVcIixcbn1cblxuZXhwb3J0IGVudW0gVHJhaWxpbmdDb21tYSB7XG4gIC8qKlxuICAgKiBUcmFpbGluZyBjb21tYXMgd2hlcmV2ZXIgcG9zc2libGUgKGluY2x1ZGluZyBmdW5jdGlvbiBhcmd1bWVudHMpLlxuICAgKi9cbiAgQUxMID0gXCJhbGxcIixcblxuICAvKipcbiAgICogVHJhaWxpbmcgY29tbWFzIHdoZXJlIHZhbGlkIGluIEVTNSAob2JqZWN0cywgYXJyYXlzLCBldGMuKVxuICAgKi9cbiAgRVM1ID0gXCJlczVcIixcblxuICAvKipcbiAgICogTm8gdHJhaWxpbmcgY29tbWFzLlxuICAgKi9cbiAgTk9ORSA9IFwibm9uZVwiLFxufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgcHJldHRpZXIgY29uZmlndXJhdGlvbi5cbiAqL1xuZXhwb3J0IGNsYXNzIFByZXR0aWVyIGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgcHVibGljIHN0YXRpYyBvZihwcm9qZWN0OiBQcm9qZWN0KTogUHJldHRpZXIgfCB1bmRlZmluZWQge1xuICAgIGNvbnN0IGlzUHJldHRpZXIgPSAoYzogQ29tcG9uZW50KTogYyBpcyBQcmV0dGllciA9PiBjIGluc3RhbmNlb2YgUHJldHRpZXI7XG4gICAgcmV0dXJuIHByb2plY3QuY29tcG9uZW50cy5maW5kKGlzUHJldHRpZXIpO1xuICB9XG4gIC8qKlxuICAgKiBEaXJlY3QgYWNjZXNzIHRvIHRoZSBwcmV0dGllciBzZXR0aW5nc1xuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHNldHRpbmdzOiBQcmV0dGllclNldHRpbmdzO1xuXG4gIC8qKlxuICAgKiBUaGUgLnByZXR0aWVySWdub3JlIGZpbGUuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgaWdub3JlRmlsZT86IElnbm9yZUZpbGU7XG5cbiAgLyoqXG4gICAqIERpcmVjdCBhY2Nlc3MgdG8gdGhlIHByZXR0aWVyIG92ZXJyaWRlc1xuICAgKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHByaXZhdGUgcmVhZG9ubHkgX292ZXJyaWRlczogUHJldHRpZXJPdmVycmlkZVtdO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IE5vZGVQcm9qZWN0LCBvcHRpb25zOiBQcmV0dGllck9wdGlvbnMpIHtcbiAgICBzdXBlcihwcm9qZWN0KTtcblxuICAgIHRoaXMuX292ZXJyaWRlcyA9IG9wdGlvbnMub3ZlcnJpZGVzID8/IFtdO1xuXG4gICAgaWYgKG9wdGlvbnMuaWdub3JlRmlsZSA/PyB0cnVlKSB7XG4gICAgICB0aGlzLmlnbm9yZUZpbGUgPSBuZXcgSWdub3JlRmlsZShwcm9qZWN0LCBcIi5wcmV0dGllcmlnbm9yZVwiKTtcbiAgICB9XG5cbiAgICBwcm9qZWN0LmFkZERldkRlcHMoXCJwcmV0dGllclwiKTtcblxuICAgIHRoaXMuc2V0dGluZ3MgPSB7XG4gICAgICAuLi5vcHRpb25zLnNldHRpbmdzLFxuICAgIH07XG5cbiAgICBpZiAob3B0aW9ucy55YW1sKSB7XG4gICAgICBuZXcgWWFtbEZpbGUocHJvamVjdCwgXCIucHJldHRpZXJyYy55bWxcIiwge1xuICAgICAgICBvYmo6ICgpID0+ICh7IC4uLnRoaXMuc2V0dGluZ3MsIG92ZXJyaWRlczogWy4uLnRoaXMuX292ZXJyaWRlc10gfSksXG4gICAgICAgIG1hcmtlcjogdHJ1ZSxcbiAgICAgIH0pO1xuICAgIH0gZWxzZSB7XG4gICAgICBuZXcgSnNvbkZpbGUocHJvamVjdCwgXCIucHJldHRpZXJyYy5qc29uXCIsIHtcbiAgICAgICAgb2JqOiAoKSA9PiAoeyAuLi50aGlzLnNldHRpbmdzLCBvdmVycmlkZXM6IFsuLi50aGlzLl9vdmVycmlkZXNdIH0pLFxuICAgICAgICBtYXJrZXI6IGZhbHNlLFxuICAgICAgfSk7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIEFkZCBhIHByZXR0aWVyIG92ZXJyaWRlXG4gICAqIEBzZWUgaHR0cHM6Ly9wcmV0dGllci5pby9kb2NzL2VuL2NvbmZpZ3VyYXRpb24uaHRtbCNjb25maWd1cmF0aW9uLW92ZXJyaWRlc1xuICAgKiBAcGFyYW0ge1ByZXR0aWVyT3ZlcnJpZGV9IG92ZXJyaWRlXG4gICAqL1xuICBwdWJsaWMgYWRkT3ZlcnJpZGUob3ZlcnJpZGU6IFByZXR0aWVyT3ZlcnJpZGUpIHtcbiAgICB0aGlzLl9vdmVycmlkZXMucHVzaChvdmVycmlkZSk7XG4gIH1cblxuICAvKipcbiAgICogRGVmaW5lcyBQcmV0dGllciBpZ25vcmUgUGF0dGVybnNcbiAgICogdGhlc2UgcGF0dGVybnMgd2lsbCBiZSBhZGRlZCB0byB0aGUgZmlsZSAucHJldHRpZXJpZ25vcmVcbiAgICpcbiAgICogQHBhcmFtIHBhdHRlcm4gZmlsZXBhdHRlcm5zIHNvIGV4Y2x1ZGUgZnJvbSBwcmV0dGllciBmb3JtYXR0aW5nXG4gICAqL1xuICBwdWJsaWMgYWRkSWdub3JlUGF0dGVybihwYXR0ZXJuOiBzdHJpbmcpIHtcbiAgICB0aGlzLmlnbm9yZUZpbGU/LmFkZFBhdHRlcm5zKHBhdHRlcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqICBSZXR1cm5zIGFsbCBQcmV0dGllciBvdmVycmlkZXNcbiAgICovXG4gIHB1YmxpYyBnZXQgb3ZlcnJpZGVzKCkge1xuICAgIHJldHVybiBbLi4udGhpcy5fb3ZlcnJpZGVzXTtcbiAgfVxuXG4gIHB1YmxpYyBwcmVTeW50aGVzaXplKCkge1xuICAgIC8vIEFkZCBhdXRvbWF0aWNhbGx5IGdlbmVyYXRlZCBTb3VyY2VDb2RlIGZpbGVzIHRvIC5wcmV0dGllcmlnbm9yZSBhcyB0aGV5IG1heSBub3QgYmUgZm9ybWF0dGVkIGNvcnJlY3RseS5cbiAgICBjb25zdCBpc1NvdXJjZUNvZGUgPSAoYzogQ29tcG9uZW50KTogYyBpcyBTb3VyY2VDb2RlID0+XG4gICAgICBjIGluc3RhbmNlb2YgU291cmNlQ29kZTtcbiAgICB0aGlzLnByb2plY3QuY29tcG9uZW50cy5maWx0ZXIoaXNTb3VyY2VDb2RlKS5mb3JFYWNoKChjKSA9PiB7XG4gICAgICB0aGlzLmFkZElnbm9yZVBhdHRlcm4oYy5maWxlUGF0aCk7XG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==