import { Project } from "./project";
/**
 * Represents a project component.
 */
export declare class Component {
    readonly project: Project;
    constructor(project: Project);
    /**
     * Called before synthesis.
     */
    preSynthesize(): void;
    /**
     * Synthesizes files to the project output directory.
     */
    synthesize(): void;
    /**
     * Called after synthesis. Order is *not* guaranteed.
     */
    postSynthesize(): void;
}
