"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryProcessMacro = void 0;
const path = require("path");
const util_1 = require("../util");
function tryProcessMacro(cwd, macro) {
    if (!macro.startsWith("$")) {
        return undefined;
    }
    const basedir = path.basename(cwd);
    switch (macro) {
        case "$BASEDIR":
            return basedir;
        case "$GIT_REMOTE":
            const origin = util_1.execOrUndefined("git remote get-url origin", { cwd });
            if (origin) {
                return origin;
            }
            const slug = getFromGitConfig(cwd, "github.user") ?? resolveEmail(cwd).split("@")[0];
            return `https://github.com/${slug}/${basedir}.git`;
        case "$GIT_USER_NAME":
            return getFromGitConfig(cwd, "user.name") ?? "user";
        case "$GIT_USER_EMAIL":
            return resolveEmail(cwd);
        case "$PYTHON_MODULE_NAME":
            return util_1.formatAsPythonModule(basedir);
    }
    return undefined;
}
exports.tryProcessMacro = tryProcessMacro;
/**
 * Returns a value from git config. Searches local and then global git config.
 * @param key the config key
 */
function getFromGitConfig(cwd, key) {
    return (util_1.execOrUndefined(`git config --get --includes ${key}`, { cwd }) ??
        util_1.execOrUndefined(`git config --get --global --includes ${key}`, { cwd }));
}
function resolveEmail(cwd) {
    return getFromGitConfig(cwd, "user.email") ?? "user@domain.com";
}
//# sourceMappingURL=data:application/json;base64,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