import { Eslint } from "../javascript";
import { GoPublishOptions, MavenPublishOptions, NugetPublishOptions, PyPiPublishOptions } from "../release";
import { TypeScriptProject, TypeScriptProjectOptions } from "../typescript";
export interface JsiiProjectOptions extends TypeScriptProjectOptions {
    /**
     * @default "."
     */
    readonly rootdir?: string;
    /**
     * Git repository URL.
     * @default $GIT_REMOTE
     */
    readonly repositoryUrl: string;
    /**
     * The name of the library author.
     * @default $GIT_USER_NAME
     */
    readonly author: string;
    /**
     * Email or URL of the library author.
     * @default $GIT_USER_EMAIL
     */
    readonly authorAddress: string;
    /**
     * Publish to maven
     * @default - no publishing
     */
    readonly publishToMaven?: JsiiJavaTarget;
    /**
     * Publish to pypi
     * @default - no publishing
     */
    readonly publishToPypi?: JsiiPythonTarget;
    /**
     * Publish Go bindings to a git repository.
     * @default - no publishing
     */
    readonly publishToGo?: JsiiGoTarget;
    /**
     * @deprecated use `publishToPyPi`
     */
    readonly python?: JsiiPythonTarget;
    /**
     * Publish to NuGet
     * @default - no publishing
     */
    readonly publishToNuget?: JsiiDotNetTarget;
    /**
     * @deprecated use `publishToNuget`
     */
    readonly dotnet?: JsiiDotNetTarget;
    /**
     * Automatically run API compatibility test against the latest version published to npm after compilation.
     *
     * - You can manually run compatibility tests using `yarn compat` if this feature is disabled.
     * - You can ignore compatibility failures by adding lines to a ".compatignore" file.
     *
     * @default false
     */
    readonly compat?: boolean;
    /**
     * Name of the ignore file for API compatibility tests.
     *
     * @default ".compatignore"
     */
    readonly compatIgnore?: string;
    /**
     * Accepts a list of glob patterns. Files matching any of those patterns will be excluded from the TypeScript compiler input.
     *
     * By default, jsii will include all *.ts files (except .d.ts files) in the TypeScript compiler input.
     * This can be problematic for example when the package's build or test procedure generates .ts files
     * that cannot be compiled with jsii's compiler settings.
     */
    readonly excludeTypescript?: string[];
    /**
     * File path for generated docs.
     * @default "API.md"
     */
    readonly docgenFilePath?: string;
    /**
     * Emit a compressed version of the assembly
     * @default false
     */
    readonly compressAssembly?: boolean;
}
export declare enum Stability {
    EXPERIMENTAL = "experimental",
    STABLE = "stable",
    DEPRECATED = "deprecated"
}
export interface JsiiJavaTarget extends MavenPublishOptions {
    readonly javaPackage: string;
    readonly mavenGroupId: string;
    readonly mavenArtifactId: string;
}
export interface JsiiPythonTarget extends PyPiPublishOptions {
    readonly distName: string;
    readonly module: string;
}
export interface JsiiDotNetTarget extends NugetPublishOptions {
    readonly dotNetNamespace: string;
    readonly packageId: string;
    readonly iconUrl?: string;
}
/**
 * Go target configuration
 */
export interface JsiiGoTarget extends GoPublishOptions {
    /**
     * The name of the target go module.
     *
     * @example github.com/owner/repo
     * @example github.com/owner/repo/subdir
     */
    readonly moduleName: string;
    /**
     * The name of the go package.
     *
     * @default - derived from the module name
     */
    readonly packageName?: string;
}
/**
 * Multi-language jsii library project
 *
 * @pjid jsii
 */
export declare class JsiiProject extends TypeScriptProject {
    readonly eslint?: Eslint;
    private readonly packageAllTask;
    constructor(options: JsiiProjectOptions);
    /**
     * Adds a target language to the build workflow and creates a package task.
     * @param language
     * @returns
     */
    private addPackagingTarget;
    private addPackagingTask;
    private pacmakForLanguage;
}
