import { __rest } from "tslib";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import clsx from 'clsx';
import styles from './styles.css.js';
import React, { useCallback, useRef } from 'react';
import useFocusVisible from '../../internal/hooks/focus-visible';
import { useEffectOnUpdate } from '../../internal/hooks/use-effect-on-update';
import Button from '../../button/internal';
import { TableTdElement } from './td-element';
import { InlineEditor } from './inline-editor';
import { useStableScrollPosition } from './use-stable-scroll-position';
const submitHandlerFallback = () => {
    throw new Error('The function `handleSubmit` is required for editable columns');
};
function TableCellEditable(_a) {
    var _b;
    var { className, item, column, isEditing, onEditStart, onEditEnd, submitEdit, ariaLabels, isVisualRefresh } = _a, rest = __rest(_a, ["className", "item", "column", "isEditing", "onEditStart", "onEditEnd", "submitEdit", "ariaLabels", "isVisualRefresh"]);
    const editActivateRef = useRef(null);
    const cellRef = useRef(null);
    const focusVisible = useFocusVisible();
    const { storeScrollPosition, restoreScrollPosition } = useStableScrollPosition(cellRef);
    const handleEditStart = () => {
        storeScrollPosition();
        if (!isEditing) {
            onEditStart();
        }
    };
    const scheduleRestoreScrollPosition = useCallback(() => setTimeout(restoreScrollPosition, 0), [restoreScrollPosition]);
    const tdNativeAttributes = Object.assign(Object.assign({}, focusVisible), { onFocus: scheduleRestoreScrollPosition, 'data-inline-editing-active': isEditing.toString() });
    useEffectOnUpdate(() => {
        if (!isEditing && editActivateRef.current) {
            editActivateRef.current.focus({ preventScroll: true });
        }
        const timer = scheduleRestoreScrollPosition();
        return () => clearTimeout(timer);
    }, [isEditing, scheduleRestoreScrollPosition]);
    return (React.createElement(TableTdElement, Object.assign({}, rest, { nativeAttributes: tdNativeAttributes, className: clsx(className, styles['body-cell-editable'], isEditing && styles['body-cell-edit-active'], isVisualRefresh && styles['is-visual-refresh']), onClick: handleEditStart, ref: cellRef }), isEditing ? (React.createElement(InlineEditor, { ariaLabels: ariaLabels, column: column, item: item, onEditEnd: onEditEnd, submitEdit: submitEdit !== null && submitEdit !== void 0 ? submitEdit : submitHandlerFallback, __onRender: restoreScrollPosition })) : (React.createElement(React.Fragment, null,
        column.cell(item),
        React.createElement("span", { className: styles['body-cell-editor'] },
            React.createElement(Button, { __hideFocusOutline: true, __internalRootRef: editActivateRef, ariaLabel: (_b = ariaLabels === null || ariaLabels === void 0 ? void 0 : ariaLabels.activateEditLabel) === null || _b === void 0 ? void 0 : _b.call(ariaLabels, column), formAction: "none", iconName: "edit", variant: "inline-icon" }))))));
}
export function TableBodyCell(_a) {
    var { isEditable } = _a, rest = __rest(_a, ["isEditable"]);
    if (isEditable || rest.isEditing) {
        return React.createElement(TableCellEditable, Object.assign({}, rest));
    }
    const { column, item } = rest;
    return React.createElement(TableTdElement, Object.assign({}, rest), column.cell(item));
}
//# sourceMappingURL=index.js.map