import React from 'react';
export interface ScreenreaderOnlyProps {
    id?: string;
    className?: string;
    children: React.ReactNode;
}
/**
 * Makes content now shown on a screen but still announced by screen-reader users.
 * The component is suitable when the aria-label cannot be used, e.g. to avoid elemnts being announced as "blank".
 *
 * To exclude screenreader-only content use `:not(.${screenreaderOnlyStyles.root})` selector, for example:
 *
 * ```
 * import screenreaderOnlyStyles from '~internal/components/screenreader-only/styles.css.js'
 *
 * let visibleContent = wrapper.find(`${styles.label}`).find(`:not(.${screenreaderOnlyStyles.root})`).getElement().textContent
 *
 * let screenreaderContent = wrapper.find(`${styles.label}`).find(`.${screenreaderOnlyStyles.root}`).getElement().textContent
 * ```
 */
export default function ScreenreaderOnly(props: ScreenreaderOnlyProps): JSX.Element;
//# sourceMappingURL=index.d.ts.map