<img src="https://i.esdrop.com/d/7o0dj05m8rnz/JNGCMedl18.png" width="45%">

[![PyPI version shields.io](https://img.shields.io/pypi/v/jupyterlab-visualpython)](https://pypi.python.org/pypi/jupyterlab-visualpython/)
![Python: 3.x](https://img.shields.io/badge/Python-3.x-yellowgreen)
[![License: GPLv3](https://img.shields.io/badge/License-GPLv3-brightgreen)](https://github.com/visualpython/visualpython/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/personalized-badge/visualpython?period=total&units=international_system&left_color=grey&right_color=orange&left_text=Downloads)](https://pepy.tech/project/visualpython)
[![Issues: ](https://img.shields.io/github/issues/visualpython/visualpython?color=%23FF6347)](https://github.com/visualpython/visualpython/issues)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/visualpython/visualpython-binder/HEAD?labpath=index.ipynb)

## Introduction
Visual Python is a GUI-based Python code generator, developed on the **Jupyter Lab**, **Jupyter Notebook** and **Google Colab** as an extension. <br>
Visual Python is an open source project started for students who struggle with coding during Python classes for data science.

<br>

Try Visual Python if you would like to: <br>
* manage big data with minimal coding skills. <br>
* help students / business analysts / researchers to overcome learning barriers for Python. <br>
* save & reuse repeatedly used codes(snippets). <br>

<br>
<img src="https://github.com/visualpython/visualpython/blob/main/img/Visual%20Python_2.2.8.gif?raw=true" width="95%">

## Getting Started with Jupyter Lab

### 1. Requirements

Visual Python is an extension to Jupyter Lab, so you must have Jupyter Lab installed already.<br>
- Python version 3.x
- Jupyter lab environment

### 2. How to Install

**1)  Install package from PyPI**
```
pip install jupyterlab-visualpython
```

**2)  Activate Visual Python on Jupyter Lab**

Click orange square button on the right side of the Jupyter Lab. 

## Getting Started with Jupyter Notebook

### 1. Requirements

Visual Python is an extension to Jupyter Notebook, so you must have Jupyter Notebook installed already.<br>
- Python version 3.x
- Jupyter notebook environment

### 2. How to Install

**1)  Install package from PyPI**
```
pip install visualpython
```

**2)  Enable the package**
```
visualpy install
```

**3)  Activate Visual Python on Jupyter Notebook**

Click orange square button on the right side of the Jupyter Notebook menu bar. 

### 3. Package Control Info
* Usage: visualpy **[option]** <br>
* Optional arguments:

```
help       - show help menu
install    - install packages
uninstall  - uninstall packages
upgrade    - version upgrade
version    - version check
```

## Getting Started with Google Colab
### 1. Requirements

Visual Python is an extension to Google Colab, so you must have Google Colab opened.<br>
- Google Colab

### 2. How to Install

**1)  Install package using Chrome Web Store**
- [Link to Visual Python for Colab](https://chrome.google.com/webstore/detail/visual-python-for-colab/ccmkpknjfagaldcgidgcipbpdipfopob)

**2)  Open Google Colab**
- [Link to Google Colab](https://colab.research.google.com/)

**3)  Activate Visual Python on Google Colab**

## Contributing
If you are interested in contributing to the Visual Python, please see [`CONTRIBUTING.md`](CONTRIBUTING.md). <br>
All skills from programmers, non-programmers, designers are welcomed.

* Programming Guide: [Developer Documentation](https://bird-energy-733.notion.site/visualpython-docs-85c0274ff7564747bb8e8d77909fc8b7)
* GUI Design Guide: [Visual Python GUI Kit 1.0](https://www.figma.com/community/file/976035035360380841)

## License
GNU GPLv3 with Visual Python special exception (See LICENSE file).

## Mission & Vision
**Mission** <br>
To support technology and education so that anyone can leverage big data analytical skills to create a variety of social values.

**Vision** <br>
To create an environment where everyone can learn and use big data analytical skills easily.

## Support Visual Python
Love Visual Python? <br>
Your support will help us continue to actively develop and improve Visual Python.☕

<a href="https://www.buymeacoffee.com/visualpython" target="_blank"><img src="https://img.buymeacoffee.com/button-api/?text=Buy me a coffee&emoji=&slug=visualpython&button_colour=ffa238&font_colour=000000&font_family=Comic&outline_colour=000000&coffee_colour=FFDD00"></a>