/*
 * Decompiled with CFR 0.152.
 */
package ca.dmoj.java;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class UnsafePrintStream
extends PrintStream {
    private BufferedWriter writer;
    private OutputStreamWriter bin;
    private OutputStream out;
    private boolean trouble;

    public UnsafePrintStream(OutputStream out, boolean isUnicode) throws UnsupportedEncodingException {
        super(new ByteArrayOutputStream());
        this.out = out;
        this.bin = new OutputStreamWriter(out, isUnicode ? "UTF-8" : "ASCII");
        this.writer = new BufferedWriter(this.bin, 4096);
    }

    @Override
    public boolean checkError() {
        return this.trouble;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    @Override
    public void write(int b) {
        try {
            this.writer.write(b);
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.flush();
        try {
            this.out.write(buf, off, len);
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    private void write(char[] buf) {
        try {
            this.writer.write(buf);
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    private void newLine() {
        try {
            this.writer.write(10);
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    @Override
    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(s);
    }

    @Override
    public void print(String s) {
        this.write(s == null ? "null" : s);
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.newLine();
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(Object x) {
        this.print(String.valueOf(x));
        this.newLine();
    }
}

