# Generated by Django 2.2.17 on 2021-05-26 07:37

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise_data', '0023_enterpriselearner'),
    ]

    operations = [
        migrations.AlterModelTable(
            name='enterpriselearner',
            table='enterprise_learner',
        ),
        migrations.CreateModel(
            name='EnterpriseLearnerEnrollment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enrollment_id', models.PositiveIntegerField(unique=True)),
                ('is_consent_granted', models.NullBooleanField(default=None)),
                ('paid_by', models.CharField(max_length=128, null=True)),
                ('user_current_enrollment_mode', models.CharField(max_length=32)),
                ('enrollment_date', models.DateTimeField()),
                ('unenrollment_date', models.DateTimeField(null=True)),
                ('unenrollment_end_within_date', models.DateTimeField(null=True)),
                ('is_refunded', models.BooleanField(default=None)),
                ('seat_delivery_method', models.CharField(max_length=128, null=True)),
                ('offer_name', models.CharField(max_length=255, null=True)),
                ('offer_type', models.CharField(max_length=128, null=True)),
                ('coupon_code', models.CharField(max_length=128, null=True)),
                ('coupon_name', models.CharField(max_length=128, null=True)),
                ('contract_id', models.CharField(max_length=128, null=True)),
                ('course_list_price', models.DecimalField(decimal_places=2, max_digits=12, null=True)),
                ('amount_learner_paid', models.DecimalField(decimal_places=2, max_digits=12, null=True)),
                ('course_key', models.CharField(db_index=True, max_length=255, null=True)),
                ('courserun_key', models.CharField(db_index=True, max_length=255, null=True)),
                ('course_title', models.CharField(db_index=True, max_length=255, null=True)),
                ('course_pacing_type', models.CharField(max_length=32, null=True)),
                ('course_start_date', models.DateTimeField(db_index=True, null=True)),
                ('course_end_date', models.DateTimeField(null=True)),
                ('course_duration_weeks', models.PositiveIntegerField()),
                ('course_max_effort', models.PositiveIntegerField(null=True)),
                ('course_min_effort', models.PositiveIntegerField(null=True)),
                ('course_primary_program', models.CharField(max_length=128, null=True)),
                ('course_primary_subject', models.CharField(max_length=128, null=True)),
                ('has_passed', models.BooleanField(default=False)),
                ('last_activity_date', models.DateField(db_index=True, null=True)),
                ('progress_status', models.CharField(max_length=128, null=True)),
                ('passed_date', models.DateTimeField(null=True)),
                ('current_grade', models.FloatField(null=True)),
                ('letter_grade', models.CharField(max_length=32, null=True)),
                ('user_email', models.CharField(db_index=True, max_length=255, null=True)),
                ('user_account_creation_date', models.DateTimeField(null=True)),
                ('user_country_code', models.CharField(max_length=2, null=True)),
                ('user_username', models.CharField(max_length=255, null=True)),
                ('enterprise_name', models.CharField(db_index=True, max_length=255)),
                ('enterprise_customer_uuid', models.UUIDField(db_index=True)),
                ('enterprise_sso_uid', models.CharField(max_length=255, null=True)),
                ('created', models.DateTimeField(db_index=True, null=True)),
                ('enterprise_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='enrollments', to='enterprise_data.EnterpriseLearner', to_field='enterprise_user_id')),
            ],
            options={
                'verbose_name': 'Enterprise Learner Enrollment',
                'verbose_name_plural': 'Enterprise Learner Enrollments',
                'db_table': 'enterprise_learner_enrollment',
            },
        ),
    ]
