/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.examples;

import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.examples.BeliefPropagation;
import org.graphframes.examples.BeliefPropagation$;
import org.graphframes.examples.Graphs$;
import org.graphframes.lib.AggregateMessages$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class BeliefPropagation$ {
    public static final BeliefPropagation$ MODULE$;

    static {
        new BeliefPropagation$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("BeliefPropagation example").getOrCreate();
        SQLContext sql = spark.sqlContext();
        GraphFrame g = Graphs$.MODULE$.gridIsingModel(sql, 3);
        Predef$.MODULE$.println((Object)"Original Ising model:");
        g.vertices().show();
        g.edges().show();
        int numIter = 5;
        GraphFrame results = this.runBPwithGraphX(g, numIter);
        Dataset beliefs = results.vertices().select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"belief"}));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Done with BP. Final beliefs after ", " iterations:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numIter)})));
        beliefs.show();
        spark.stop();
    }

    private GraphFrame colorGraph(GraphFrame g) {
        UserDefinedFunction colorUDF = functions$.MODULE$.udf((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int i, int j) {
                return this.apply$mcIII$sp(i, j);
            }

            public int apply$mcIII$sp(int i, int j) {
                return (i + j) % 2;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        Dataset v = g.vertices().withColumn("color", colorUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("i"), functions$.MODULE$.col("j")})));
        return GraphFrame$.MODULE$.apply((Dataset<Row>)v, g.edges());
    }

    public GraphFrame runBPwithGraphX(GraphFrame g, int numIter) {
        GraphFrame colorG = this.colorGraph(g);
        int numColors = (int)colorG.vertices().select("color", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        Graph<Row, Row> gx0 = colorG.toGraphX();
        Map<String, Object> vColsMap = colorG.vertexColumnMap();
        Map<String, Object> eColsMap = colorG.edgeColumnMap();
        Serializable x$5 = new Serializable(vColsMap){
            public static final long serialVersionUID = 0L;
            private final Map vColsMap$1;

            public final BeliefPropagation.VertexAttr apply(long x0$1, Row x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
                if (tuple2 != null) {
                    Row attr = (Row)tuple2._2();
                    BeliefPropagation.VertexAttr vertexAttr = new BeliefPropagation.VertexAttr(attr.getDouble(BoxesRunTime.unboxToInt((Object)this.vColsMap$1.apply((Object)"a"))), 0.0, attr.getInt(BoxesRunTime.unboxToInt((Object)this.vColsMap$1.apply((Object)"color"))));
                    return vertexAttr;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.vColsMap$1 = vColsMap$1;
            }
        };
        ClassTag x$6 = ClassTag$.MODULE$.apply(BeliefPropagation.VertexAttr.class);
        gx0.mapVertices$default$3((Function2)x$5);
        Object x$7 = null;
        Graph gx1 = gx0.mapVertices((Function2)x$5, x$6, null);
        Serializable extractEdgeAttr = new Serializable(eColsMap){
            public static final long serialVersionUID = 0L;
            private final Map eColsMap$1;

            public final BeliefPropagation.EdgeAttr apply(Edge<Row> e) {
                return new BeliefPropagation.EdgeAttr(((Row)e.attr()).getDouble(BoxesRunTime.unboxToInt((Object)this.eColsMap$1.apply((Object)"b"))));
            }
            {
                this.eColsMap$1 = eColsMap$1;
            }
        };
        ObjectRef gx = ObjectRef.create((Object)gx1.mapEdges((Function1)extractEdgeAttr, ClassTag$.MODULE$.apply(BeliefPropagation.EdgeAttr.class)));
        scala.package$.MODULE$.Range().apply(0, numIter).foreach$mVc$sp((Function1)new Serializable(numColors, gx){
            public static final long serialVersionUID = 0L;
            private final int numColors$1;
            public final ObjectRef gx$1;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                scala.package$.MODULE$.Range().apply(0, this.numColors$1).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.runBPwithGraphX.1 $outer;

                    public final void apply(int color) {
                        this.apply$mcVI$sp(color);
                    }

                    public void apply$mcVI$sp(int color) {
                        Graph qual$1 = (Graph)this.$outer.gx$1.elem;
                        Serializable x$8 = new Serializable(this, color){
                            public static final long serialVersionUID = 0L;
                            private final int color$1;

                            public final void apply(EdgeContext<BeliefPropagation.VertexAttr, BeliefPropagation.EdgeAttr, Object> ctx) {
                                double msg;
                                if (((BeliefPropagation.VertexAttr)ctx.dstAttr()).color() == this.color$1) {
                                    double msg2 = ((BeliefPropagation.EdgeAttr)ctx.attr()).b() * ((BeliefPropagation.VertexAttr)ctx.srcAttr()).belief();
                                    if (msg2 != 0.0) {
                                        ctx.sendToDst((Object)BoxesRunTime.boxToDouble((double)msg2));
                                    }
                                } else if (((BeliefPropagation.VertexAttr)ctx.srcAttr()).color() == this.color$1 && (msg = ((BeliefPropagation.EdgeAttr)ctx.attr()).b() * ((BeliefPropagation.VertexAttr)ctx.dstAttr()).belief()) != 0.0) {
                                    ctx.sendToSrc((Object)BoxesRunTime.boxToDouble((double)msg));
                                }
                            }
                            {
                                this.color$1 = color$1;
                            }
                        };
                        Serializable x$9 = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x$1, double x$2) {
                                return this.apply$mcDDD$sp(x$1, x$2);
                            }

                            public double apply$mcDDD$sp(double x$1, double x$2) {
                                return x$1 + x$2;
                            }
                        };
                        TripletFields x$10 = qual$1.aggregateMessages$default$3();
                        VertexRDD msgs = qual$1.aggregateMessages((Function1)x$8, (Function2)x$9, x$10, ClassTag$.MODULE$.Double());
                        this.$outer.gx$1.elem = ((Graph)this.$outer.gx$1.elem).outerJoinVertices((RDD)msgs, (Function3)new Serializable(this, color){
                            public static final long serialVersionUID = 0L;
                            private final int color$1;

                            public final BeliefPropagation.VertexAttr apply(long x0$2, BeliefPropagation.VertexAttr x1$2, Option<Object> x2$1) {
                                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$2, x2$1);
                                if (tuple3 != null) {
                                    BeliefPropagation.VertexAttr vertexAttr;
                                    BeliefPropagation.VertexAttr vAttr = (BeliefPropagation.VertexAttr)tuple3._2();
                                    Option optMsg = (Option)tuple3._3();
                                    if (vAttr.color() == this.color$1) {
                                        double x = vAttr.a() + BoxesRunTime.unboxToDouble((Object)optMsg.getOrElse((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final double apply() {
                                                return this.apply$mcD$sp();
                                            }

                                            public double apply$mcD$sp() {
                                                return 0.0;
                                            }
                                        }));
                                        double newBelief = scala.math.package$.MODULE$.exp(-BeliefPropagation$.MODULE$.org$graphframes$examples$BeliefPropagation$$log1pExp(-x));
                                        vertexAttr = new BeliefPropagation.VertexAttr(vAttr.a(), newBelief, this.color$1);
                                    } else {
                                        vertexAttr = vAttr;
                                    }
                                    BeliefPropagation.VertexAttr vertexAttr2 = vertexAttr;
                                    return vertexAttr2;
                                }
                                throw new MatchError((Object)tuple3);
                            }
                            {
                                this.color$1 = color$1;
                            }
                        }, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BeliefPropagation.VertexAttr.class), Predef.$eq$colon$eq$.MODULE$.tpEquals());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.numColors$1 = numColors$1;
                this.gx$1 = gx$1;
            }
        });
        Graph qual$2 = (Graph)gx.elem;
        Serializable x$11 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(long x$3, BeliefPropagation.VertexAttr attr) {
                return attr.belief();
            }
        };
        ClassTag x$12 = ClassTag$.MODULE$.Double();
        qual$2.mapVertices$default$3((Function2)x$11);
        Object x$13 = null;
        Graph gxFinal = qual$2.mapVertices((Function2)x$11, x$12, null).mapEdges((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Edge<BeliefPropagation.EdgeAttr> x$4) {
            }
        }, ClassTag$.MODULE$.Unit());
        return GraphFrame$.MODULE$.fromGraphX(colorG, gxFinal, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"belief"}))), GraphFrame$.MODULE$.fromGraphX$default$4(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Unit());
    }

    public GraphFrame runBPwithGraphFrames(GraphFrame g, int numIter) {
        GraphFrame colorG = this.colorGraph(g);
        int numColors = (int)colorG.vertices().select("color", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        ObjectRef gx = ObjectRef.create((Object)GraphFrame$.MODULE$.apply((Dataset<Row>)colorG.vertices().withColumn("belief", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0))), colorG.edges()));
        scala.package$.MODULE$.Range().apply(0, numIter).foreach$mVc$sp((Function1)new Serializable(numColors, gx){
            public static final long serialVersionUID = 0L;
            private final int numColors$2;
            public final ObjectRef gx$2;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                scala.package$.MODULE$.Range().apply(0, this.numColors$2).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.runBPwithGraphFrames.1 $outer;

                    public final void apply(int color) {
                        this.apply$mcVI$sp(color);
                    }

                    public void apply$mcVI$sp(int color) {
                        AggregateMessages$ AM = AggregateMessages$.MODULE$;
                        Column msgForSrc = functions$.MODULE$.when(AM.src().apply((Object)"color").$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)color)), (Object)AM.edge().apply((Object)"b").$times((Object)AM.dst().apply((Object)"belief")));
                        Column msgForDst = functions$.MODULE$.when(AM.dst().apply((Object)"color").$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)color)), (Object)AM.edge().apply((Object)"b").$times((Object)AM.src().apply((Object)"belief")));
                        UserDefinedFunction logistic = functions$.MODULE$.udf((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x) {
                                return this.apply$mcDD$sp(x);
                            }

                            public double apply$mcDD$sp(double x) {
                                return scala.math.package$.MODULE$.exp(-BeliefPropagation$.MODULE$.org$graphframes$examples$BeliefPropagation$$log1pExp(-x));
                            }
                        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                        Dataset<Row> aggregates = ((GraphFrame)this.$outer.gx$2.elem).aggregateMessages().sendToSrc(msgForSrc).sendToDst(msgForDst).agg(functions$.MODULE$.sum(AM.msg()).as("aggMess"));
                        Dataset<Row> v = ((GraphFrame)this.$outer.gx$2.elem).vertices();
                        Column newBeliefCol = functions$.MODULE$.when(v.apply("color").$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)color)).$amp$amp((Object)aggregates.apply("aggMess").isNotNull()), (Object)logistic.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{aggregates.apply("aggMess").$plus((Object)v.apply("a"))}))).otherwise((Object)v.apply("belief"));
                        Dataset newVertices = v.join(aggregates, v.apply("id").$eq$eq$eq((Object)aggregates.apply("id")), "left_outer").drop(aggregates.apply("id")).withColumn("newBelief", newBeliefCol).drop("aggMess").drop("belief").withColumnRenamed("newBelief", "belief");
                        Dataset<Row> cachedNewVertices = AM.getCachedDataFrame((Dataset<Row>)newVertices);
                        this.$outer.gx$2.elem = GraphFrame$.MODULE$.apply(cachedNewVertices, ((GraphFrame)this.$outer.gx$2.elem).edges());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.numColors$2 = numColors$2;
                this.gx$2 = gx$2;
            }
        });
        return GraphFrame$.MODULE$.apply((Dataset<Row>)((GraphFrame)gx.elem).vertices().drop("color"), ((GraphFrame)gx.elem).edges());
    }

    public double org$graphframes$examples$BeliefPropagation$$log1pExp(double x) {
        return x > 0.0 ? x + scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(-x)) : scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(x));
    }

    private BeliefPropagation$() {
        MODULE$ = this;
    }
}

