# -*- coding: utf-8 -*-
# Generated by Django 1.11.7 on 2017-11-09 16:57
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import shop.money.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ShippingDestination',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('country', models.CharField(max_length=3)),
                ('price', shop.money.fields.MoneyField()),
            ],
            options={
                'verbose_name': 'Shipping Destination',
                'verbose_name_plural': 'Shipping Destination',
            },
        ),
        migrations.CreateModel(
            name='ShippingMethod',
            fields=[
                ('id', models.PositiveIntegerField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('carrier', models.CharField(max_length=32)),
                ('min_weight', models.DecimalField(decimal_places=3, max_digits=6)),
                ('max_weight', models.DecimalField(decimal_places=3, max_digits=8)),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
            ],
            options={
                'verbose_name': 'Shipping Method',
                'verbose_name_plural': 'Shipping Methods',
            },
        ),
        migrations.AddField(
            model_name='shippingdestination',
            name='shipping_method',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='destinations', to='shop_sendcloud.ShippingMethod'),
        ),
        migrations.AlterUniqueTogether(
            name='shippingdestination',
            unique_together=set([('country', 'shipping_method')]),
        ),
    ]
