"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("@aws-cdk/aws-events");
const kinesis = require("@aws-cdk/aws-kinesis");
const cdk = require("@aws-cdk/core");
const targets = require("../../lib");
// ---------------------------------
// Define a rule that triggers a put to a Kinesis stream every 1min.
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-kinesis-event-target');
const stream = new kinesis.Stream(stack, 'MyStream');
const event = new events.Rule(stack, 'EveryMinute', {
    schedule: events.Schedule.rate(cdk.Duration.minutes(1)),
});
event.addTarget(new targets.KinesisStream(stream, {
    partitionKeyPath: events.EventField.eventId,
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcua2luZXNpcy1zdHJlYW0uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5raW5lc2lzLXN0cmVhbS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLDhDQUE4QztBQUM5QyxnREFBZ0Q7QUFDaEQscUNBQXFDO0FBQ3JDLHFDQUFxQztBQUVyQyxvQ0FBb0M7QUFDcEMsb0VBQW9FO0FBRXBFLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsOEJBQThCLENBQUMsQ0FBQztBQUVqRSxNQUFNLE1BQU0sR0FBRyxJQUFJLE9BQU8sQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQ3JELE1BQU0sS0FBSyxHQUFHLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFO0lBQ2xELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztDQUN4RCxDQUFDLENBQUM7QUFFSCxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksT0FBTyxDQUFDLGFBQWEsQ0FBQyxNQUFNLEVBQUU7SUFDaEQsZ0JBQWdCLEVBQUUsTUFBTSxDQUFDLFVBQVUsQ0FBQyxPQUFPO0NBQzVDLENBQUMsQ0FBQyxDQUFDO0FBRUosR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZXZlbnRzIGZyb20gJ0Bhd3MtY2RrL2F3cy1ldmVudHMnO1xuaW1wb3J0ICogYXMga2luZXNpcyBmcm9tICdAYXdzLWNkay9hd3Mta2luZXNpcyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyB0YXJnZXRzIGZyb20gJy4uLy4uL2xpYic7XG5cbi8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxuLy8gRGVmaW5lIGEgcnVsZSB0aGF0IHRyaWdnZXJzIGEgcHV0IHRvIGEgS2luZXNpcyBzdHJlYW0gZXZlcnkgMW1pbi5cblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1jZGsta2luZXNpcy1ldmVudC10YXJnZXQnKTtcblxuY29uc3Qgc3RyZWFtID0gbmV3IGtpbmVzaXMuU3RyZWFtKHN0YWNrLCAnTXlTdHJlYW0nKTtcbmNvbnN0IGV2ZW50ID0gbmV3IGV2ZW50cy5SdWxlKHN0YWNrLCAnRXZlcnlNaW51dGUnLCB7XG4gIHNjaGVkdWxlOiBldmVudHMuU2NoZWR1bGUucmF0ZShjZGsuRHVyYXRpb24ubWludXRlcygxKSksXG59KTtcblxuZXZlbnQuYWRkVGFyZ2V0KG5ldyB0YXJnZXRzLktpbmVzaXNTdHJlYW0oc3RyZWFtLCB7XG4gIHBhcnRpdGlvbktleVBhdGg6IGV2ZW50cy5FdmVudEZpZWxkLmV2ZW50SWQsXG59KSk7XG5cbmFwcC5zeW50aCgpO1xuIl19