"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const events = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
const targets = require("../../lib");
const app = new cdk.App();
class AwsApi extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // Force new deployment of 'cool-service' and stop 'dev-instance' at midnight everyday
        const scheduleRule = new events.Rule(this, 'ScheduleRule', {
            schedule: events.Schedule.cron({
                hour: '0',
                minute: '0',
            }),
        });
        scheduleRule.addTarget(new targets.AwsApi({
            service: 'ECS',
            action: 'updateService',
            parameters: {
                service: 'cool-service',
                forceNewDeployment: true,
            },
        }));
        scheduleRule.addTarget(new targets.AwsApi({
            service: 'RDS',
            action: 'stopDBInstance',
            parameters: {
                DBInstanceIdentifier: 'dev-instance',
            },
        }));
        // Create snapshots when a DB instance restarts
        const patternRule = new events.Rule(this, 'PatternRule', {
            eventPattern: {
                detailType: ['RDS DB Instance Event'],
                detail: {
                    Message: ['DB instance restarted'],
                },
            },
        });
        patternRule.addTarget(new targets.AwsApi({
            service: 'RDS',
            action: 'createDBSnapshot',
            parameters: {
                DBInstanceIdentifier: events.EventField.fromPath('$.detail.SourceArn'),
            },
        }));
    }
}
new AwsApi(app, 'aws-cdk-aws-api-target-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,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