"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SfnStateMachine = void 0;
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Use a StepFunctions state machine as a target for Amazon EventBridge rules.
 */
class SfnStateMachine {
    /**
     *
     */
    constructor(machine, props = {}) {
        var _a;
        this.machine = machine;
        this.props = props;
        if (props.role) {
            props.role.grant(new iam.ServicePrincipal('events.amazonaws.com'));
        }
        // no statements are passed because we are configuring permissions by using grant* helper below
        this.role = (_a = props.role) !== null && _a !== void 0 ? _a : util_1.singletonEventRole(machine, []);
        machine.grantStartExecution(this.role);
    }
    /**
     * Returns a properties that are used in an Rule to trigger this State Machine.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     */
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.machine.stateMachineArn,
            role: this.role,
            input: this.props.input,
            targetResource: this.machine,
        };
    }
}
exports.SfnStateMachine = SfnStateMachine;
//# sourceMappingURL=data:application/json;base64,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