"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipeline = void 0;
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Allows the pipeline to be used as an EventBridge rule target.
 */
class CodePipeline {
    /**
     *
     */
    constructor(pipeline, options = {}) {
        this.pipeline = pipeline;
        this.options = options;
    }
    /**
     * Returns the rule target specification.
     *
     * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
     */
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.pipeline.pipelineArn,
            role: this.options.eventRole || util_1.singletonEventRole(this.pipeline, [new iam.PolicyStatement({
                    resources: [this.pipeline.pipelineArn],
                    actions: ['codepipeline:StartPipelineExecution'],
                })]),
            targetResource: this.pipeline,
        };
    }
}
exports.CodePipeline = CodePipeline;
//# sourceMappingURL=data:application/json;base64,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