"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchJob = void 0;
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * (experimental) Use an AWS Batch Job / Queue as an event rule target.
 *
 * @experimental
 */
class BatchJob {
    /**
     * @experimental
     */
    constructor(jobQueue, jobDefinition, props = {}) {
        this.jobQueue = jobQueue;
        this.jobDefinition = jobDefinition;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger queue this batch job as a result from an EventBridge event.
     *
     * @experimental
     */
    bind(rule, _id) {
        var _a;
        const batchParameters = {
            jobDefinition: this.jobDefinition.jobDefinitionArn,
            jobName: (_a = this.props.jobName) !== null && _a !== void 0 ? _a : rule.node.uniqueId,
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        return {
            id: '',
            arn: this.jobQueue.jobQueueArn,
            // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
            // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
            role: util_1.singletonEventRole(this.jobDefinition, [
                new iam.PolicyStatement({
                    actions: ['batch:SubmitJob'],
                    resources: [
                        this.jobDefinition.jobDefinitionArn,
                        this.jobQueue.jobQueueArn,
                    ],
                }),
            ]),
            input: this.props.event,
            targetResource: this.jobQueue,
            batchParameters,
        };
    }
}
exports.BatchJob = BatchJob;
//# sourceMappingURL=data:application/json;base64,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