# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class ApplicationLoadBalancerForwardingRuleProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'name': 'str',

        'protocol': 'str',

        'listener_ip': 'str',

        'listener_port': 'int',

        'client_timeout': 'int',

        'server_certificates': 'list[str]',

        'http_rules': 'list[ApplicationLoadBalancerHttpRule]',
    }

    attribute_map = {

        'name': 'name',

        'protocol': 'protocol',

        'listener_ip': 'listenerIp',

        'listener_port': 'listenerPort',

        'client_timeout': 'clientTimeout',

        'server_certificates': 'serverCertificates',

        'http_rules': 'httpRules',
    }

    def __init__(self, name=None, protocol=None, listener_ip=None, listener_port=None, client_timeout=None, server_certificates=None, http_rules=None, local_vars_configuration=None):  # noqa: E501
        """ApplicationLoadBalancerForwardingRuleProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._protocol = None
        self._listener_ip = None
        self._listener_port = None
        self._client_timeout = None
        self._server_certificates = None
        self._http_rules = None
        self.discriminator = None

        self.name = name
        self.protocol = protocol
        self.listener_ip = listener_ip
        self.listener_port = listener_port
        if client_timeout is not None:
            self.client_timeout = client_timeout
        if server_certificates is not None:
            self.server_certificates = server_certificates
        if http_rules is not None:
            self.http_rules = http_rules


    @property
    def name(self):
        """Gets the name of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501

        The name of the Application Load Balancer forwarding rule.  # noqa: E501

        :return: The name of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ApplicationLoadBalancerForwardingRuleProperties.

        The name of the Application Load Balancer forwarding rule.  # noqa: E501

        :param name: The name of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def protocol(self):
        """Gets the protocol of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501

        Balancing protocol  # noqa: E501

        :return: The protocol of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this ApplicationLoadBalancerForwardingRuleProperties.

        Balancing protocol  # noqa: E501

        :param protocol: The protocol of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type protocol: str
        """
        if self.local_vars_configuration.client_side_validation and protocol is None:  # noqa: E501
            raise ValueError("Invalid value for `protocol`, must not be `None`")  # noqa: E501
        allowed_values = ["HTTP"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and protocol not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"  # noqa: E501
                .format(protocol, allowed_values)
            )

        self._protocol = protocol

    @property
    def listener_ip(self):
        """Gets the listener_ip of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501

        Listening (inbound) IP  # noqa: E501

        :return: The listener_ip of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._listener_ip

    @listener_ip.setter
    def listener_ip(self, listener_ip):
        """Sets the listener_ip of this ApplicationLoadBalancerForwardingRuleProperties.

        Listening (inbound) IP  # noqa: E501

        :param listener_ip: The listener_ip of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type listener_ip: str
        """
        if self.local_vars_configuration.client_side_validation and listener_ip is None:  # noqa: E501
            raise ValueError("Invalid value for `listener_ip`, must not be `None`")  # noqa: E501

        self._listener_ip = listener_ip

    @property
    def listener_port(self):
        """Gets the listener_port of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501

        Listening (inbound) port number; valid range is 1 to 65535.  # noqa: E501

        :return: The listener_port of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: int
        """
        return self._listener_port

    @listener_port.setter
    def listener_port(self, listener_port):
        """Sets the listener_port of this ApplicationLoadBalancerForwardingRuleProperties.

        Listening (inbound) port number; valid range is 1 to 65535.  # noqa: E501

        :param listener_port: The listener_port of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type listener_port: int
        """
        if self.local_vars_configuration.client_side_validation and listener_port is None:  # noqa: E501
            raise ValueError("Invalid value for `listener_port`, must not be `None`")  # noqa: E501

        self._listener_port = listener_port

    @property
    def client_timeout(self):
        """Gets the client_timeout of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501

        The maximum time in milliseconds to wait for the client to acknowledge or send data; default is 50,000 (50 seconds).  # noqa: E501

        :return: The client_timeout of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: int
        """
        return self._client_timeout

    @client_timeout.setter
    def client_timeout(self, client_timeout):
        """Sets the client_timeout of this ApplicationLoadBalancerForwardingRuleProperties.

        The maximum time in milliseconds to wait for the client to acknowledge or send data; default is 50,000 (50 seconds).  # noqa: E501

        :param client_timeout: The client_timeout of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type client_timeout: int
        """

        self._client_timeout = client_timeout

    @property
    def server_certificates(self):
        """Gets the server_certificates of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501

        Array of items in the collection.  # noqa: E501

        :return: The server_certificates of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._server_certificates

    @server_certificates.setter
    def server_certificates(self, server_certificates):
        """Sets the server_certificates of this ApplicationLoadBalancerForwardingRuleProperties.

        Array of items in the collection.  # noqa: E501

        :param server_certificates: The server_certificates of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type server_certificates: list[str]
        """

        self._server_certificates = server_certificates

    @property
    def http_rules(self):
        """Gets the http_rules of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501

        An array of items in the collection. The original order of rules is perserved during processing, except for Forward-type rules are processed after the rules with other action defined. The relative order of Forward-type rules is also preserved during the processing.  # noqa: E501

        :return: The http_rules of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: list[ApplicationLoadBalancerHttpRule]
        """
        return self._http_rules

    @http_rules.setter
    def http_rules(self, http_rules):
        """Sets the http_rules of this ApplicationLoadBalancerForwardingRuleProperties.

        An array of items in the collection. The original order of rules is perserved during processing, except for Forward-type rules are processed after the rules with other action defined. The relative order of Forward-type rules is also preserved during the processing.  # noqa: E501

        :param http_rules: The http_rules of this ApplicationLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type http_rules: list[ApplicationLoadBalancerHttpRule]
        """

        self._http_rules = http_rules
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApplicationLoadBalancerForwardingRuleProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApplicationLoadBalancerForwardingRuleProperties):
            return True

        return self.to_dict() != other.to_dict()
