# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['imageedit']

package_data = \
{'': ['*'], 'imageedit': ['resources/*']}

install_requires = \
['metprint>=2020.5,<2021.0',
 'pillow>=7.1.1,<8.0.0',
 'pyppeteer>=0.0.25,<0.0.26']

setup_kwargs = {
    'name': 'imageedit',
    'version': '2020.4.1',
    'description': 'Create various icon masks and shading effects with the imageedit library',
    'long_description': '[![Github top language](https://img.shields.io/github/languages/top/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../)\n[![Codacy grade](https://img.shields.io/codacy/grade/caca6f53db3a44f08b7cbdb25284e784.svg?style=for-the-badge)](https://www.codacy.com/manual/FHPythonUtils/ImageRound)\n[![Codacy coverage](https://img.shields.io/codacy/coverage/caca6f53db3a44f08b7cbdb25284e784.svg?style=for-the-badge)](https://www.codacy.com/manual/FHPythonUtils/ImageRound)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/imageedit.svg?style=for-the-badge)](https://pypi.org/project/imageedit/)\n[![PyPI Version](https://img.shields.io/pypi/v/imageedit.svg?style=for-the-badge)](https://pypi.org/project/imageedit/)\n\n<!-- omit in toc -->\n# ImageEdit\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\n[**Now available on pypi.org!**](https://pypi.org/project/imageedit/)\n\nCreate various icon masks and shading effects with the imageedit library.\nFour example files: round.py, makeProjIcons.py, makePWAImages.py and\ngetPWAScreenshots.py. Includes imagetracer.py. imagetracer.py uses JS and is\nmuch faster than previous implementations. Takes a few seconds and has no cap.\n\n- [Documentation](#documentation)\n- [Example usage and docs for layered images](#example-usage-and-docs-for-layered-images)\n- [Example Files](#example-files)\n- [Comparison to similar solutions](#comparison-to-similar-solutions)\n\t- [GUI](#gui)\n\t- [Web](#web)\n\t- [Advantages of this solution](#advantages-of-this-solution)\n\t- [Disadvantages of this solution](#disadvantages-of-this-solution)\n- [How to use out of the box (makePWAImages)](#how-to-use-out-of-the-box-makepwaimages)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [Download](#download-1)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n- [Screenshots](#screenshots)\n\t- [Desktop](#desktop)\n\n## Documentation\nGenerate docs with\n```bash\npydocmd simple imageedit.effects++ imageedit.imagegrab++ imageedit.imagetracer++ imageedit.io++ imageedit.transform++ > Docs.md\n```\n\nSee the [Docs](/Docs.md) for more information.\n\n## Example usage and docs for layered images\n\nLayered images are supported. When manually adding and inserting layers,\none can use the `addLayerRaster` and `insertLayerRaster` functions to add a\nPIL Image as a layer.\n\nAlternatively, use `addLayer` and `insertLayer` to add a Layer object as a layer\n\n```python\nclass Layer:\n\t""" A representation of an image layer """\n\tdef __init__(self, image, name, offsets, opacity, visible, dimensions):\n\t\tself.image = image\n\t\tself.name = name\n\t\tself.offsets = offsets # Doesn\'t look to be required\n\t\tself.opacity = opacity\n\t\tself.visible = visible\n\t\tself.dimensions = dimensions\n\n\nclass LayeredImage:\n\t""" A representation of a layered image such as an ora """\n\tdef __init__(self, layers, dimensions):\n\t\tself.layers = layers\n\t\tself.dimensions = dimensions\n\n\tdef addLayerRaster(self, image, name, offsets=(0, 0)):\n\t\t""" The recommended way to add a layer """\n\n\tdef insertLayerRaster(self, image, name, index, offsets=(0, 0)):\n\t\t""" The recommended way to insert a layer """\n\n\tdef getLayer(self, index):\n\t\t""" Get a layer """\n\n\tdef addLayer(self, layer):\n\t\t""" Add a layer """\n\n\tdef insertLayer(self, layer, index):\n\t\t""" Insert a layer at a specific index """\n\n\tdef removeLayer(self, index):\n\t\t""" Remove a layer at a specific index """\n\n\tdef getFlattenLayers(self, ignoreHidden=True):\n\t\t""" Return an image for all flattened layers """\n\n\tdef getFlattenTwoLayers(self, background, foreground, ignoreHidden=True):\n\t\t""" Return an image for two flattened layers """\n\n\tdef flattenTwoLayers(self, background, foreground, ignoreHidden=True):\n\t\t""" Flatten two layers """\n\n\tdef flattenLayers(self, ignoreHidden=True):\n\t\t""" Flatten all layers """\n```\n\nTo modify a layer you would need to do something like:\n```python\n# Grab the PIL Image from a layer and do stuff\nlayer = layeredImage.getLayer(1).image\ncrop = imageedit.transform.cropCentre(layer, 100, 100)\n# Remove the old layer 1 and raster the new layer 1\nlayeredImage.removeLayer(1)\nlayeredImage.insertLayerRaster(crop, "Cropped Layer @1", 1, offsets=(50, 0))\n```\n\n\n## Example Files\n- round.py\n- makeProjIcons.py\n- makePWAImages.py\n- readWriteLayered.py\n- getPWAScreenshots.py\n\n## Comparison to similar solutions\n\nSimilar solutions include but are not limited to:\n\n### GUI\nhttps://www.getpaint.net/\n\n### Web\nhttps://realfavicongenerator.net/\n\n### Advantages of this solution\n- Minimal: few dependencies required (python and pillow)\n- Quick: when given a regular or mask image it can produce a large number or\nvariants in a relatively short amount of time\n- Customisable: write your own scripts to leverage imageEdit (python knowledge\nrequired)\n- Produce a PWA mask icon out of the box\n- SVG tracing lib doesn\'t require potrace/ pypotrace which can be challenging to\nset up on Windows\n- SVG tracing using imageTracerJs.py (https://github.com/jankovicsandras/imagetracerjs)\nis pretty good (requires pyppeteer: https://github.com/miyakogi/pyppeteer)\n\n### Disadvantages of this solution\n- Specific image dimensions needed out of the box: whilst this is something that\ncould be changed, maskable icons are 640x640 and regular icons are 512x512\n\n## How to use out of the box (makePWAImages)\n\n1. Put regular 512x512 image or mask 640x640 image under main/input in this\nexample I am using lightfox.png\n\n\t<img src="readme-assets/examples/lightfox.png" alt="LightFox" width="128">\n\n2. Run ```makePWAImages.py``` and navigate to main/output/lightfox.png/pwa\n\n<div>\n<img src="readme-assets/examples/mask.png" alt="LightFox" width="128">\n<img src="readme-assets/examples/round-192.png" alt="LightFox" width="38">\n<img src="readme-assets/examples/round-512.png" alt="LightFox" width="102">\n<img src="readme-assets/examples/square-180.png" alt="LightFox" width="36">\n<img src="readme-assets/examples/squircle-256.png" alt="LightFox" width="52">\n</div>\n\n\n## Install With PIP\n\n```python\npip install imageedit\n```\n\nHead to https://pypi.org/project/imageedit/ for more info\n\nSee python files under main for example usage\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.8.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.8\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.8 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.8)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## Download\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to clone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/[user-name]/[repository]\n```\n\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nIn the interest of fostering an open and welcoming environment, we\nas contributors and maintainers pledge to make participation in our\nproject and our community a harassment-free experience for everyone.\nPlease see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md) for more information.\n\n### Contributing\nContributions are welcome, please see the [Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md) for more information.\n\n### Security\nThank you for improving the security of the project, please see the [Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md) for more information.\n\n## Screenshots\n\n### Desktop\n<div>\n<img src="readme-assets/screenshots/desktop/screenshot-0.png" alt="Screenshot 1" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-1.png" alt="Screenshot 2" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-2.png" alt="Screenshot 3" width="600">\n</div>\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FredHappyface/Python.ImageEdit',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
