"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelResourceIDs = void 0;
const util_1 = require("./util");
const definition_1 = require("./definition");
class ModelResourceIDs {
    static ModelTableResourceID(typeName) {
        return `${typeName}Table`;
    }
    static ModelTableStreamArn(typeName) {
        return `${typeName}TableStreamArn`;
    }
    static ModelTableDataSourceID(typeName) {
        return `${typeName}DataSource`;
    }
    static ModelTableIAMRoleID(typeName) {
        return `${typeName}IAMRole`;
    }
    static ModelFilterInputTypeName(name) {
        const nameOverride = definition_1.DEFAULT_SCALARS[name];
        if (nameOverride) {
            return `Model${nameOverride}FilterInput`;
        }
        return `Model${name}FilterInput`;
    }
    static ModelFilterScalarInputTypeName(name, includeFilter) {
        const nameOverride = definition_1.DEFAULT_SCALARS[name];
        if (nameOverride) {
            return `Model${nameOverride}${includeFilter ? 'Filter' : ''}Input`;
        }
        return `Model${name}${includeFilter ? 'Filter' : ''}Input`;
    }
    static ModelConditionInputTypeName(name) {
        const nameOverride = definition_1.DEFAULT_SCALARS[name];
        if (nameOverride) {
            return `Model${nameOverride}ConditionInput`;
        }
        return `Model${name}ConditionInput`;
    }
    static ModelKeyConditionInputTypeName(name) {
        const nameOverride = definition_1.DEFAULT_SCALARS[name];
        if (nameOverride) {
            return `Model${nameOverride}KeyConditionInput`;
        }
        return `Model${name}KeyConditionInput`;
    }
    static ModelCompositeKeyArgumentName(keyFieldNames) {
        return util_1.toCamelCase(keyFieldNames.map(n => util_1.graphqlName(n)));
    }
    static ModelCompositeKeySeparator() {
        return '#';
    }
    static ModelCompositeAttributeName(keyFieldNames) {
        return keyFieldNames.join(ModelResourceIDs.ModelCompositeKeySeparator());
    }
    static ModelCompositeKeyConditionInputTypeName(modelName, keyName) {
        return `Model${modelName}${keyName}CompositeKeyConditionInput`;
    }
    static ModelCompositeKeyInputTypeName(modelName, keyName) {
        return `Model${modelName}${keyName}CompositeKeyInput`;
    }
    static ModelFilterListInputTypeName(name, includeFilter) {
        const nameOverride = definition_1.DEFAULT_SCALARS[name];
        if (nameOverride) {
            return `Model${nameOverride}List${includeFilter ? 'Filter' : ''}Input`;
        }
        return `Model${name}List${includeFilter ? 'Filter' : ''}Input`;
    }
    static ModelScalarFilterInputTypeName(name, includeFilter) {
        const nameOverride = definition_1.DEFAULT_SCALARS[name];
        if (nameOverride) {
            return `Model${nameOverride}${includeFilter ? 'Filter' : ''}Input`;
        }
        return `Model${name}${includeFilter ? 'Filter' : ''}Input`;
    }
    static ModelConnectionTypeName(typeName) {
        return `Model${typeName}Connection`;
    }
    static ModelDeleteInputObjectName(typeName) {
        return util_1.graphqlName('Delete' + util_1.toUpper(typeName) + 'Input');
    }
    static ModelUpdateInputObjectName(typeName) {
        return util_1.graphqlName('Update' + util_1.toUpper(typeName) + 'Input');
    }
    static ModelCreateInputObjectName(typeName) {
        return util_1.graphqlName(`Create` + util_1.toUpper(typeName) + 'Input');
    }
    static ModelOnCreateSubscriptionName(typeName) {
        return util_1.graphqlName(`onCreate` + util_1.toUpper(typeName));
    }
    static ModelOnUpdateSubscriptionName(typeName) {
        return util_1.graphqlName(`onUpdate` + util_1.toUpper(typeName));
    }
    static ModelOnDeleteSubscriptionName(typeName) {
        return util_1.graphqlName(`onDelete` + util_1.toUpper(typeName));
    }
    static ModelAttributeTypesName() {
        return `ModelAttributeTypes`;
    }
    static ModelSizeInputTypeName() {
        return `ModelSizeInput`;
    }
    static NonModelInputObjectName(typeName) {
        return util_1.graphqlName(util_1.toUpper(typeName) + 'Input');
    }
    static UrlParamsInputObjectName(typeName, fieldName) {
        return util_1.graphqlName(util_1.toUpper(typeName) + util_1.toUpper(fieldName) + 'ParamsInput');
    }
    static HttpQueryInputObjectName(typeName, fieldName) {
        return util_1.graphqlName(util_1.toUpper(typeName) + util_1.toUpper(fieldName) + 'QueryInput');
    }
    static HttpBodyInputObjectName(typeName, fieldName) {
        return util_1.graphqlName(util_1.toUpper(typeName) + util_1.toUpper(fieldName) + 'BodyInput');
    }
}
exports.ModelResourceIDs = ModelResourceIDs;
//# sourceMappingURL=ModelResourceIDs.js.map