import { Expression, ObjectNode, CompoundExpressionNode, ListNode, BooleanNode } from './ast';
export declare class SearchableMappingTemplate {
    static genericTemplate({ operation, path, params, }: {
        operation: Expression;
        path: Expression;
        params: Expression | ObjectNode | CompoundExpressionNode;
    }): ObjectNode;
    static searchItem({ query, size, search_after, from, path, sort, version, }: {
        path: Expression;
        sort?: Expression | ObjectNode;
        query?: ObjectNode | Expression;
        size?: Expression;
        search_after?: Expression | ListNode;
        from?: Expression;
        version?: BooleanNode;
        aggs?: Expression | ObjectNode;
    }): ObjectNode;
    static searchTemplate({ query, size, search_after, from, path, sort, version, aggs, }: {
        path: Expression;
        sort?: Expression | ObjectNode;
        query?: ObjectNode | Expression;
        size?: Expression;
        search_after?: Expression | ListNode;
        from?: Expression;
        version?: BooleanNode;
        aggs?: Expression | ObjectNode;
    }): ObjectNode;
}
//# sourceMappingURL=searchable.d.ts.map