import { StringParameter, NumberParameter, DeletionPolicy } from 'cloudform-types';
import Output from 'cloudform-types/types/output';
import { SyncConfig } from 'graphql-transformer-core';
import Template from 'cloudform-types/types/template';
import { InputObjectTypeDefinitionNode } from 'graphql';
declare type MutationResolverInput = {
    type: string;
    syncConfig: SyncConfig;
    nameOverride?: string;
    mutationTypeName?: string;
    timestamps?: {
        createdAtField?: string;
        updatedAtField?: string;
    };
};
declare type MutationUpdateResolverInput = MutationResolverInput & {
    optionalNonNullableFields: string[];
};
export declare class ResourceFactory {
    makeParams(): {
        [x: string]: StringParameter | NumberParameter;
    };
    initTemplate(): Template;
    makeAppSyncAPI(): import("cloudform-types/types/appSync/graphQlApi").default;
    makeAppSyncSchema(schema: string): import("cloudform-types/types/appSync/graphQlSchema").default;
    makeAPIIDOutput(): Output;
    makeAPIEndpointOutput(): Output;
    makeTableStreamArnOutput(resourceId: string): Output;
    makeDataSourceOutput(resourceId: string): Output;
    makeTableNameOutput(resourceId: string): Output;
    makeModelTable(typeName: string, hashKey?: string, rangeKey?: string, deletionPolicy?: DeletionPolicy, isSyncEnabled?: boolean): import("cloudform-types/types/dynamoDb/table").default;
    private dynamoDBTableName;
    makeIAMRole(typeName: string, syncConfig?: SyncConfig): import("cloudform-types/types/iam/role").default;
    makeDynamoDBDataSource(tableId: string, iamRoleLogicalID: string, typeName: string, isSyncEnabled?: boolean): import("cloudform-types/types/appSync/dataSource").default;
    makeCreateResolver({ type, nameOverride, syncConfig, mutationTypeName }: MutationResolverInput): import("cloudform-types/types/appSync/resolver").default;
    initalizeDefaultInputForCreateMutation(input: InputObjectTypeDefinitionNode, timestamps: any): string;
    makeUpdateResolver({ type, nameOverride, syncConfig, mutationTypeName, timestamps, optionalNonNullableFields, }: MutationUpdateResolverInput): import("cloudform-types/types/appSync/resolver").default;
    makeGetResolver(type: string, nameOverride?: string, isSyncEnabled?: boolean, queryTypeName?: string): import("cloudform-types/types/appSync/resolver").default;
    makeSyncResolver(type: string, queryTypeName?: string): import("cloudform-types/types/appSync/resolver").default;
    makeQueryResolver(type: string, nameOverride?: string, isSyncEnabled?: boolean, queryTypeName?: string): import("cloudform-types/types/appSync/resolver").default;
    makeListResolver(type: string, improvePluralization: boolean, nameOverride?: string, isSyncEnabled?: boolean, queryTypeName?: string): import("cloudform-types/types/appSync/resolver").default;
    makeDeleteResolver({ type, nameOverride, syncConfig, mutationTypeName }: MutationResolverInput): import("cloudform-types/types/appSync/resolver").default;
    private addDefaultConditionExpression;
}
export {};
//# sourceMappingURL=resources.d.ts.map