export declare type HookExtensions = Record<string, {
    runtime: string;
    runtime_windows?: string;
}>;
export declare type HooksConfig = {
    extensions?: HookExtensions;
    ignore?: string[];
};
export declare type HookFileMeta = {
    baseName: string;
    extension?: string;
    filePath?: string;
    fileName: string;
};
export declare type EventPrefix = 'pre' | 'post';
export declare type HookEvent = {
    command: string;
    subCommand?: string;
    argv: string[];
    eventPrefix?: EventPrefix;
    forcePush: boolean;
};
export declare type DataParameter = {
    amplify: {
        version?: string;
        environment?: string;
        command?: string;
        subCommand?: string;
        argv?: string[];
    };
};
export declare type ErrorParameter = {
    message: string;
    stack: string;
};
export declare type HooksVerb = 'add' | 'update' | 'remove' | 'push' | 'pull' | 'publish' | 'delete' | 'checkout' | 'list' | 'get' | 'mock' | 'build' | 'status' | 'import' | 'gqlcompile' | 'addgraphqldatasource' | 'statements' | 'types';
export declare type HooksNoun = 'notifications' | 'analytics' | 'api' | 'auth' | 'function' | 'hosting' | 'interactions' | 'predictions' | 'storage' | 'xr' | 'codegen' | 'env';
//# sourceMappingURL=hooksTypes.d.ts.map