import { HookEvent, DataParameter, EventPrefix, ErrorParameter } from './hooksTypes';
export declare class HooksMeta {
    private static instance?;
    private hookEvent;
    private dataParameter;
    private errorParameter?;
    static getInstance: (input?: {
        command?: string | undefined;
        plugin?: string | undefined;
        subCommands?: string[] | undefined;
        options?: {
            forcePush?: boolean | undefined;
        } | undefined;
        argv?: string[] | undefined;
    } | undefined, eventPrefix?: EventPrefix | undefined, errorParameter?: ErrorParameter | undefined) => HooksMeta;
    private constructor();
    getDataParameter(): DataParameter;
    getErrorParameter(): ErrorParameter | undefined;
    getHookEvent(): HookEvent;
    setEnvironmentName(envName?: string): void;
    setAmplifyVersion(amplifyVersion: string): void;
    setErrorParameter(errorParameter?: ErrorParameter): void;
    setEventCommand(command: string): void;
    setEventSubCommand(subCommand?: string): void;
    setEventPrefix(prefix?: EventPrefix): void;
    mergeDataParameter(newDataParameter: DataParameter): void;
    setHookEventFromInput(input?: {
        command?: string;
        plugin?: string;
        subCommands?: string[];
        argv?: string[];
        options?: {
            forcePush?: boolean;
        };
    }): void;
}
//# sourceMappingURL=hooksMeta.d.ts.map