import { CLIEnvironmentProvider } from '..';
import { FeatureFlagRegistration, FeatureFlagsEntry } from '.';
export declare class FeatureFlags {
    private environmentProvider;
    private projectPath;
    private useNewDefaults;
    private static instance;
    private readonly registrations;
    private fileValueProvider;
    private envValueProvider;
    private effectiveFlags;
    private newProjectDefaults;
    private existingProjectDefaults;
    private constructor();
    static initialize: (environmentProvider: CLIEnvironmentProvider, useNewDefaults?: boolean, additionalFlags?: Record<string, FeatureFlagRegistration[]> | undefined) => Promise<void>;
    static ensureDefaultFeatureFlags: (newProject: boolean) => Promise<void>;
    static getBoolean: (flagName: string) => boolean;
    static getString: (flagName: string) => string;
    static getNumber: (flagName: string) => number;
    static getEffectiveFlags: () => Readonly<FeatureFlagsEntry>;
    static getNewProjectDefaults: () => Readonly<FeatureFlagsEntry>;
    static getExistingProjectDefaults: () => Readonly<FeatureFlagsEntry>;
    static removeFeatureFlagConfiguration: (removeProjectConfiguration: boolean, envNames: string[]) => Promise<void>;
    static isInitialized: () => boolean;
    static reloadValues: () => Promise<void>;
    private static removeOriginalConfigFile;
    private static ensureInitialized;
    private getValue;
    private buildJSONSchemaFromRegistrations;
    private buildDefaultValues;
    private validateFlags;
    private transformEnvFlags;
    private loadValues;
    private registerFlag;
    private registerFlags;
}
//# sourceMappingURL=featureFlags.d.ts.map