"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotInitializedError = exports.ConfigurationError = exports.UnrecognizedFrameworkError = exports.AppIdMismatchError = exports.AngularConfigNotFoundError = exports.SchemaDoesNotExistError = exports.AppAlreadyDeployedError = exports.AppNotFoundError = exports.TeamProviderInfoMigrateError = exports.FrontendBuildError = exports.InvalidSubCommandError = exports.InvalidEnvironmentNameError = exports.NonEmptyDirectoryError = exports.MissingParametersError = exports.EnvironmentDoesNotExistError = exports.UnknownArgumentError = exports.UnknownResourceTypeError = exports.ResourceCredentialsNotFoundError = exports.ResourceDoesNotExistError = exports.ResourceAlreadyExistsError = exports.NotImplementedError = void 0;
class NotImplementedError extends Error {
}
exports.NotImplementedError = NotImplementedError;
class ResourceAlreadyExistsError extends Error {
}
exports.ResourceAlreadyExistsError = ResourceAlreadyExistsError;
class ResourceDoesNotExistError extends Error {
}
exports.ResourceDoesNotExistError = ResourceDoesNotExistError;
class ResourceCredentialsNotFoundError extends Error {
}
exports.ResourceCredentialsNotFoundError = ResourceCredentialsNotFoundError;
class UnknownResourceTypeError extends Error {
}
exports.UnknownResourceTypeError = UnknownResourceTypeError;
class UnknownArgumentError extends Error {
}
exports.UnknownArgumentError = UnknownArgumentError;
class EnvironmentDoesNotExistError extends Error {
}
exports.EnvironmentDoesNotExistError = EnvironmentDoesNotExistError;
class MissingParametersError extends Error {
}
exports.MissingParametersError = MissingParametersError;
class NonEmptyDirectoryError extends Error {
}
exports.NonEmptyDirectoryError = NonEmptyDirectoryError;
class InvalidEnvironmentNameError extends Error {
}
exports.InvalidEnvironmentNameError = InvalidEnvironmentNameError;
class InvalidSubCommandError extends Error {
}
exports.InvalidSubCommandError = InvalidSubCommandError;
class FrontendBuildError extends Error {
}
exports.FrontendBuildError = FrontendBuildError;
class TeamProviderInfoMigrateError extends Error {
}
exports.TeamProviderInfoMigrateError = TeamProviderInfoMigrateError;
class AppNotFoundError extends Error {
}
exports.AppNotFoundError = AppNotFoundError;
class AppAlreadyDeployedError extends Error {
}
exports.AppAlreadyDeployedError = AppAlreadyDeployedError;
class SchemaDoesNotExistError extends Error {
}
exports.SchemaDoesNotExistError = SchemaDoesNotExistError;
class AngularConfigNotFoundError extends Error {
}
exports.AngularConfigNotFoundError = AngularConfigNotFoundError;
class AppIdMismatchError extends Error {
}
exports.AppIdMismatchError = AppIdMismatchError;
class UnrecognizedFrameworkError extends Error {
}
exports.UnrecognizedFrameworkError = UnrecognizedFrameworkError;
class ConfigurationError extends Error {
}
exports.ConfigurationError = ConfigurationError;
class NotInitializedError extends Error {
    constructor() {
        super();
        this.name = 'NotInitializedError';
        this.message = `
      No Amplify backend project files detected within this folder. Either initialize a new Amplify project or pull an existing project.
      - "amplify init" to initialize a new Amplify project
      - "amplify pull <app-id>" to pull your existing Amplify project. Find the <app-id> in the AWS Console or Amplify Admin UI.
        `;
        this.stack = undefined;
    }
}
exports.NotInitializedError = NotInitializedError;
//# sourceMappingURL=index.js.map