from typing import Any, ClassVar, Iterator, List, Optional, Tuple, overload
import datetime

import numpy

try:
    import numpy.typing
    NDArrayDateTime64 = numpy.typing.NDArray[numpy.datetime64]
    NDArrayComplex128 = numpy.typing.NDArray[numpy.complex128]
    NDArrayFloat64 = numpy.typing.NDArray[numpy.float64]
except ImportError:
    NDArrayDateTime64 = numpy.ndarray
    NDArrayComplex128 = numpy.ndarray
    NDArrayFloat64 = numpy.ndarray


class AstronomicAngle:
    def __init__(self, date: Optional[datetime.datetime] = None) -> None:
        ...

    @property
    def h(self) -> float:
        ...

    @property
    def i(self) -> float:
        ...

    @property
    def n(self) -> float:
        ...

    @property
    def nu(self) -> float:
        ...

    @property
    def nuprim(self) -> float:
        ...

    @property
    def nusec(self) -> float:
        ...

    @property
    def p(self) -> float:
        ...

    @property
    def p1(self) -> float:
        ...

    @property
    def r(self) -> float:
        ...

    @property
    def s(self) -> float:
        ...

    @property
    def t(self) -> float:
        ...

    @property
    def x1ra(self) -> float:
        ...

    @property
    def xi(self) -> float:
        ...


class Wave:
    class Ident:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        k2MK3: ClassVar[Wave.Ident] = ...
        k2MK6: ClassVar[Wave.Ident] = ...
        k2MN2: ClassVar[Wave.Ident] = ...
        k2MN6: ClassVar[Wave.Ident] = ...
        k2MS2: ClassVar[Wave.Ident] = ...
        k2MS6: ClassVar[Wave.Ident] = ...
        k2N2: ClassVar[Wave.Ident] = ...
        k2Q1: ClassVar[Wave.Ident] = ...
        k2SM2: ClassVar[Wave.Ident] = ...
        k2SM6: ClassVar[Wave.Ident] = ...
        kChi1: ClassVar[Wave.Ident] = ...
        kEps2: ClassVar[Wave.Ident] = ...
        kEta2: ClassVar[Wave.Ident] = ...
        kJ1: ClassVar[Wave.Ident] = ...
        kK1: ClassVar[Wave.Ident] = ...
        kK2: ClassVar[Wave.Ident] = ...
        kL2: ClassVar[Wave.Ident] = ...
        kLambda2: ClassVar[Wave.Ident] = ...
        kM11: ClassVar[Wave.Ident] = ...
        kM12: ClassVar[Wave.Ident] = ...
        kM13: ClassVar[Wave.Ident] = ...
        kM2: ClassVar[Wave.Ident] = ...
        kM3: ClassVar[Wave.Ident] = ...
        kM4: ClassVar[Wave.Ident] = ...
        kM6: ClassVar[Wave.Ident] = ...
        kM8: ClassVar[Wave.Ident] = ...
        kMK3: ClassVar[Wave.Ident] = ...
        kMK4: ClassVar[Wave.Ident] = ...
        kMKS2: ClassVar[Wave.Ident] = ...
        kMN4: ClassVar[Wave.Ident] = ...
        kMNS2: ClassVar[Wave.Ident] = ...
        kMO3: ClassVar[Wave.Ident] = ...
        kMP1: ClassVar[Wave.Ident] = ...
        kMS4: ClassVar[Wave.Ident] = ...
        kMSK6: ClassVar[Wave.Ident] = ...
        kMSN2: ClassVar[Wave.Ident] = ...
        kMSN6: ClassVar[Wave.Ident] = ...
        kMSf: ClassVar[Wave.Ident] = ...
        kMf: ClassVar[Wave.Ident] = ...
        kMm: ClassVar[Wave.Ident] = ...
        kMsqm: ClassVar[Wave.Ident] = ...
        kMtm: ClassVar[Wave.Ident] = ...
        kMu2: ClassVar[Wave.Ident] = ...
        kN2: ClassVar[Wave.Ident] = ...
        kN4: ClassVar[Wave.Ident] = ...
        kNu2: ClassVar[Wave.Ident] = ...
        kO1: ClassVar[Wave.Ident] = ...
        kOO1: ClassVar[Wave.Ident] = ...
        kP1: ClassVar[Wave.Ident] = ...
        kPhi1: ClassVar[Wave.Ident] = ...
        kPi1: ClassVar[Wave.Ident] = ...
        kPsi1: ClassVar[Wave.Ident] = ...
        kQ1: ClassVar[Wave.Ident] = ...
        kR2: ClassVar[Wave.Ident] = ...
        kR4: ClassVar[Wave.Ident] = ...
        kRho1: ClassVar[Wave.Ident] = ...
        kS1: ClassVar[Wave.Ident] = ...
        kS2: ClassVar[Wave.Ident] = ...
        kS4: ClassVar[Wave.Ident] = ...
        kS6: ClassVar[Wave.Ident] = ...
        kSK4: ClassVar[Wave.Ident] = ...
        kSN4: ClassVar[Wave.Ident] = ...
        kSa: ClassVar[Wave.Ident] = ...
        kSigma1: ClassVar[Wave.Ident] = ...
        kSsa: ClassVar[Wave.Ident] = ...
        kT2: ClassVar[Wave.Ident] = ...
        kTheta1: ClassVar[Wave.Ident] = ...

        def __init__(self, value: int) -> None:
            ...

        def __eq__(self, other: object) -> bool:
            ...

        def __getstate__(self) -> int:
            ...

        def __hash__(self) -> int:
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

        def __ne__(self, other: object) -> bool:
            ...

        def __setstate__(self, state: int) -> None:
            ...

        @property
        def name(self) -> str:
            ...

        @property
        def value(self) -> int:
            ...

    class TidalType:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kLongPeriod: ClassVar[Wave.TidalType] = ...
        kShortPeriod: ClassVar[Wave.TidalType] = ...

        def __init__(self, value: int) -> None:
            ...

        def __eq__(self, other: object) -> bool:
            ...

        def __getstate__(self) -> int:
            ...

        def __hash__(self) -> int:
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

        def __ne__(self, other: object) -> bool:
            ...

        def __setstate__(self, state: int) -> None:
            ...

        @property
        def name(self) -> str:
            ...

        @property
        def value(self) -> int:
            ...

    def __init__(self, *args, **kwargs) -> None:
        ...

    def name(self) -> str:
        ...

    def nodal_a(self, a: AstronomicAngle) -> None:
        ...

    def nodal_g(self, a: AstronomicAngle) -> None:
        ...

    def v(self) -> float:
        ...

    def vu(self) -> float:
        ...

    @property
    def f(self) -> float:
        ...

    @property
    def freq(self) -> float:
        ...

    @property
    def ident(self) -> Wave.Ident:
        ...

    @property
    def type(self) -> Wave.TidalType:
        ...

    @property
    def u(self) -> float:
        ...


class WaveTable:
    def __init__(self, waves: List[str] = ...) -> None:
        ...

    def compute_nodal_corrections(self,
                                  date: datetime.datetime) -> AstronomicAngle:
        ...

    def compute_nodal_modulations(
            self,
            dates: NDArrayDateTime64) -> Tuple[NDArrayFloat64, NDArrayFloat64]:
        ...

    @staticmethod
    def harmonic_analysis(h: NDArrayFloat64, f: NDArrayFloat64,
                          vu: NDArrayFloat64) -> NDArrayComplex128:
        ...

    @staticmethod
    def known_constituents() -> List[str]:
        ...

    def tide_from_mapping(self, date: datetime.datetime,
                          wave: NDArrayComplex128) -> NDArrayFloat64:
        ...

    def tide_from_tide_series(self, dates: NDArrayDateTime64,
                              wave: NDArrayComplex128) -> NDArrayFloat64:
        ...

    @overload
    def wave(self, ident: Wave.Ident) -> Wave:
        ...

    @overload
    def wave(self, ident: str) -> Wave:
        ...

    @overload
    def __getitem__(self, index: int) -> Wave:
        ...

    @overload
    def __getitem__(self, slice: slice) -> List[Wave]:
        ...

    def __getstate__(self) -> tuple:
        ...

    def __iter__(self) -> Iterator:
        ...

    def __len__(self) -> int:
        ...

    def __setstate__(self, arg0: tuple) -> None:
        ...


def timestamp(date: datetime.datetime) -> float:
    ...
