"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.collectPackageSecondaryEntryPoints = exports.recursivelyCollectSecondaryEntryPointsFromDirectory = exports.getNonNodeModulesSubDirs = exports.collectWorkspaceLibrarySecondaryEntryPoints = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
const package_json_1 = require("nx/src/utils/package-json");
const workspace_root_1 = require("nx/src/utils/workspace-root");
const path_2 = require("nx/src/utils/path");
const fileutils_1 = require("nx/src/utils/fileutils");
function collectWorkspaceLibrarySecondaryEntryPoints(library, tsconfigPathAliases) {
    const libraryRoot = (0, path_1.join)(workspace_root_1.workspaceRoot, library.root);
    const needsSecondaryEntryPointsCollected = (0, fs_1.existsSync)((0, path_1.join)(libraryRoot, 'ng-package.json'));
    const secondaryEntryPoints = [];
    if (needsSecondaryEntryPointsCollected) {
        const tsConfigAliasesForLibWithSecondaryEntryPoints = Object.entries(tsconfigPathAliases).reduce((acc, [tsKey, tsPaths]) => {
            if (!tsKey.startsWith(library.importKey)) {
                return Object.assign({}, acc);
            }
            if (tsPaths.some((path) => path.startsWith(`${library.root}/`))) {
                acc = Object.assign(Object.assign({}, acc), { [tsKey]: tsPaths });
            }
            return acc;
        }, {});
        for (const [alias] of Object.entries(tsConfigAliasesForLibWithSecondaryEntryPoints)) {
            const pathToLib = (0, path_1.dirname)((0, path_1.join)(workspace_root_1.workspaceRoot, tsconfigPathAliases[alias][0]));
            let searchDir = pathToLib;
            while (searchDir !== libraryRoot) {
                if ((0, fs_1.existsSync)((0, path_1.join)(searchDir, 'ng-package.json'))) {
                    secondaryEntryPoints.push({ name: alias, path: pathToLib });
                    break;
                }
                searchDir = (0, path_1.dirname)(searchDir);
            }
        }
    }
    return secondaryEntryPoints;
}
exports.collectWorkspaceLibrarySecondaryEntryPoints = collectWorkspaceLibrarySecondaryEntryPoints;
function getNonNodeModulesSubDirs(directory) {
    return (0, fs_1.readdirSync)(directory)
        .filter((file) => file !== 'node_modules')
        .map((file) => (0, path_1.join)(directory, file))
        .filter((file) => (0, fs_1.lstatSync)(file).isDirectory());
}
exports.getNonNodeModulesSubDirs = getNonNodeModulesSubDirs;
function recursivelyCollectSecondaryEntryPointsFromDirectory(pkgName, pkgVersion, pkgRoot, mainEntryPointExports, directories, collectedPackages) {
    for (const directory of directories) {
        const packageJsonPath = (0, path_1.join)(directory, 'package.json');
        const relativeEntryPointPath = (0, path_1.relative)(pkgRoot, directory);
        const entryPointName = (0, path_2.joinPathFragments)(pkgName, relativeEntryPointPath);
        if ((0, fs_1.existsSync)(packageJsonPath)) {
            try {
                // require the secondary entry point to try to rule out sample code
                require.resolve(entryPointName, { paths: [workspace_root_1.workspaceRoot] });
                const { name } = (0, fileutils_1.readJsonFile)(packageJsonPath);
                // further check to make sure what we were able to require is the
                // same as the package name
                if (name === entryPointName) {
                    collectedPackages.push({ name, version: pkgVersion });
                }
            }
            catch (_a) { }
        }
        else if (mainEntryPointExports) {
            // if the package.json doesn't exist, check if the directory is
            // exported by the main entry point
            const entryPointExportKey = `./${relativeEntryPointPath}`;
            const entryPointInfo = mainEntryPointExports[entryPointExportKey];
            if (entryPointInfo) {
                collectedPackages.push({
                    name: entryPointName,
                    version: pkgVersion,
                });
            }
        }
        const subDirs = getNonNodeModulesSubDirs(directory);
        recursivelyCollectSecondaryEntryPointsFromDirectory(pkgName, pkgVersion, pkgRoot, mainEntryPointExports, subDirs, collectedPackages);
    }
}
exports.recursivelyCollectSecondaryEntryPointsFromDirectory = recursivelyCollectSecondaryEntryPointsFromDirectory;
function collectPackageSecondaryEntryPoints(pkgName, pkgVersion, collectedPackages) {
    let pathToPackage;
    let packageJsonPath;
    let packageJson;
    try {
        ({ path: packageJsonPath, packageJson } = (0, package_json_1.readModulePackageJson)(pkgName));
        pathToPackage = (0, path_1.dirname)(packageJsonPath);
    }
    catch (_a) {
        // the package.json might not resolve if the package has the "exports"
        // entry and is not exporting the package.json file, fall back to trying
        // to find it from the top-level node_modules
        pathToPackage = (0, path_1.join)(workspace_root_1.workspaceRoot, 'node_modules', pkgName);
        packageJsonPath = (0, path_1.join)(pathToPackage, 'package.json');
        if (!(0, fs_1.existsSync)(packageJsonPath)) {
            // might not exist if it's nested in another package, just return here
            return;
        }
        packageJson = (0, fileutils_1.readJsonFile)(packageJsonPath);
    }
    const { exports } = packageJson;
    const subDirs = getNonNodeModulesSubDirs(pathToPackage);
    recursivelyCollectSecondaryEntryPointsFromDirectory(pkgName, pkgVersion, pathToPackage, exports, subDirs, collectedPackages);
}
exports.collectPackageSecondaryEntryPoints = collectPackageSecondaryEntryPoints;
//# sourceMappingURL=secondary-entry-points.js.map