"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nx = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
var Nx;
(function (Nx) {
    /**
     * Supported enums for a TargetDependency.
     */
    let TargetDependencyProject;
    (function (TargetDependencyProject) {
        /**
         * Only rely on the package where the target is called.
         *
         * This is usually done for test like targets where you only want to run unit
         * tests on the target packages without testing all dependent packages.
         */
        TargetDependencyProject["SELF"] = "self";
        /**
         * Target relies on executing the target against all dependencies first.
         *
         * This is usually done for build like targets where you want to build all
         * dependant projects first.
         */
        TargetDependencyProject["DEPENDENCIES"] = "dependencies";
    })(TargetDependencyProject = Nx.TargetDependencyProject || (Nx.TargetDependencyProject = {}));
})(Nx = exports.Nx || (exports.Nx = {}));
//# sourceMappingURL=data:application/json;base64,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