"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_private_bucket_1 = require("@pepperize/cdk-private-bucket");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * A GitLab Runner cache consisting of an Amazon S3 bucket.
 *
 * The bucket is encrypted with a KMS managed master key, it has public access blocked and will be cleared and deleted on CFN stack deletion.
 */
class Cache extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const bucketName = props.bucketName || "runner-cache";
        const uniqueCacheBucketName = `${bucketName}-${aws_cdk_lib_1.Names.uniqueId(this)}`.slice(-63).toLocaleLowerCase();
        /* Enabled if not 0. If 0 - cache doesn't expire. If undefined - expiration sets to expire in 30 days */
        const expiration = props.expiration ?? aws_cdk_lib_1.Duration.days(30);
        const lifeCycleRuleEnabled = expiration.toDays() !== 0;
        this.bucket = new cdk_private_bucket_1.PrivateBucket(scope, "CacheBucket", {
            bucketName: uniqueCacheBucketName,
            lifecycleRules: [
                {
                    enabled: lifeCycleRuleEnabled,
                    expiration: expiration,
                },
            ],
            autoDeleteObjects: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Cache", version: "0.2.291" };
//# sourceMappingURL=data:application/json;base64,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