/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.razorvine.serpent.ParseException;
import net.razorvine.serpent.SeekableStringReader;
import net.razorvine.serpent.ast.Ast;
import net.razorvine.serpent.ast.BigIntNode;
import net.razorvine.serpent.ast.BooleanNode;
import net.razorvine.serpent.ast.ComplexNumberNode;
import net.razorvine.serpent.ast.DictNode;
import net.razorvine.serpent.ast.DoubleNode;
import net.razorvine.serpent.ast.INode;
import net.razorvine.serpent.ast.IntegerNode;
import net.razorvine.serpent.ast.KeyValueNode;
import net.razorvine.serpent.ast.ListNode;
import net.razorvine.serpent.ast.LongNode;
import net.razorvine.serpent.ast.NoneNode;
import net.razorvine.serpent.ast.PrimitiveNode;
import net.razorvine.serpent.ast.SetNode;
import net.razorvine.serpent.ast.StringNode;
import net.razorvine.serpent.ast.TupleNode;

public class Parser {
    final String FloatCharacters = "-+.eE0123456789";
    final String IntCharacters = "-0123456789";

    public Ast parse(byte[] serialized) throws ParseException {
        try {
            return this.parse(new String(serialized, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseException(e.toString());
        }
    }

    public Ast parse(String expression) {
        Ast ast = new Ast();
        if (expression == null || expression.length() == 0) {
            return ast;
        }
        SeekableStringReader sr = new SeekableStringReader(expression);
        if (sr.peek() == '#') {
            sr.readUntil('\n');
        }
        try {
            ast.root = this.parseExpr(sr);
            sr.skipWhitespace();
            if (sr.hasMore()) {
                throw new ParseException("garbage at end of expression");
            }
            return ast;
        }
        catch (ParseException x) {
            String faultLocation = this.extractFaultLocation(sr);
            throw new ParseException(x.getMessage() + " (at position " + sr.bookmark() + "; '" + faultLocation + "')", x);
        }
    }

    String extractFaultLocation(SeekableStringReader sr) {
        SeekableStringReader.StringContext ctx = sr.context(-1, 20);
        return String.format("...%s>>><<<%s...", ctx.left, ctx.right);
    }

    INode parseExpr(SeekableStringReader sr) {
        sr.skipWhitespace();
        if (!sr.hasMore()) {
            throw new ParseException("unexpected end of line, missing expression or close/open character");
        }
        char c = sr.peek();
        INode node = c == '{' || c == '[' || c == '(' ? this.parseCompound(sr) : this.parseSingle(sr);
        sr.skipWhitespace();
        return node;
    }

    INode parseCompound(SeekableStringReader sr) {
        sr.skipWhitespace();
        switch (sr.peek()) {
            case '[': {
                return this.parseList(sr);
            }
            case '{': {
                int bm = sr.bookmark();
                try {
                    return this.parseSet(sr);
                }
                catch (ParseException x) {
                    sr.flipBack(bm);
                    return this.parseDict(sr);
                }
            }
            case '(': {
                int bm = sr.bookmark();
                String betweenparens = sr.readUntil(")\n").trim();
                sr.flipBack(bm);
                return betweenparens.endsWith("j") ? this.parseComplex(sr) : this.parseTuple(sr);
            }
        }
        throw new ParseException("invalid sequencetype char");
    }

    TupleNode parseTuple(SeekableStringReader sr) {
        sr.read();
        sr.skipWhitespace();
        TupleNode tuple = new TupleNode();
        if (sr.peek() == ')') {
            sr.read();
            return tuple;
        }
        INode firstelement = this.parseExpr(sr);
        if (sr.peek() == ',') {
            sr.read();
            sr.skipWhitespace();
            if (sr.read() == ')') {
                tuple.elements.add(firstelement);
                return tuple;
            }
            sr.rewind(1);
        }
        tuple.elements = this.parseExprList(sr);
        tuple.elements.add(0, firstelement);
        sr.skipWhitespace();
        if (!sr.hasMore()) {
            throw new ParseException("missing ')'");
        }
        if (sr.peek() == ',') {
            sr.read();
        }
        if (!sr.hasMore()) {
            throw new ParseException("missing ')'");
        }
        char closechar = sr.read();
        if (closechar == ',') {
            closechar = sr.read();
        }
        if (closechar != ')') {
            throw new ParseException("expected ')'");
        }
        return tuple;
    }

    List<INode> parseExprList(SeekableStringReader sr) {
        ArrayList<INode> exprList = new ArrayList<INode>();
        exprList.add(this.parseExpr(sr));
        while (sr.hasMore() && sr.peek() == ',') {
            sr.read();
            try {
                exprList.add(this.parseExpr(sr));
            }
            catch (ParseException x) {
                sr.rewind(1);
                break;
            }
        }
        return exprList;
    }

    List<INode> parseKeyValueList(SeekableStringReader sr) {
        ArrayList<INode> kvs = new ArrayList<INode>();
        kvs.add(this.parseKeyValue(sr));
        while (sr.hasMore() && sr.peek() == ',') {
            sr.read();
            try {
                kvs.add(this.parseKeyValue(sr));
            }
            catch (ParseException x) {
                sr.rewind(1);
                break;
            }
        }
        return kvs;
    }

    KeyValueNode parseKeyValue(SeekableStringReader sr) {
        INode key = this.parseExpr(sr);
        if (sr.hasMore() && sr.peek() == ':') {
            sr.read();
            INode value = this.parseExpr(sr);
            KeyValueNode kv = new KeyValueNode();
            kv.key = key;
            kv.value = value;
            return kv;
        }
        throw new ParseException("expected ':'");
    }

    SetNode parseSet(SeekableStringReader sr) {
        sr.read();
        sr.skipWhitespace();
        SetNode setnode = new SetNode();
        List<INode> elts = this.parseExprList(sr);
        sr.skipWhitespace();
        if (!sr.hasMore()) {
            throw new ParseException("missing '}'");
        }
        if (sr.peek() == ',') {
            sr.read();
        }
        if (!sr.hasMore()) {
            throw new ParseException("missing '}'");
        }
        char closechar = sr.read();
        if (closechar != '}') {
            throw new ParseException("expected '}'");
        }
        HashSet<INode> h = new HashSet<INode>(elts);
        setnode.elements = new ArrayList<INode>(h);
        return setnode;
    }

    ListNode parseList(SeekableStringReader sr) {
        sr.read();
        sr.skipWhitespace();
        ListNode list = new ListNode();
        if (sr.peek() == ']') {
            sr.read();
            return list;
        }
        list.elements = this.parseExprList(sr);
        sr.skipWhitespace();
        if (!sr.hasMore()) {
            throw new ParseException("missing ']'");
        }
        if (sr.peek() == ',') {
            sr.read();
        }
        if (!sr.hasMore()) {
            throw new ParseException("missing ']'");
        }
        char closechar = sr.read();
        if (closechar != ']') {
            throw new ParseException("expected ']'");
        }
        return list;
    }

    INode parseDict(SeekableStringReader sr) {
        sr.read();
        sr.skipWhitespace();
        DictNode dict = new DictNode();
        if (sr.peek() == '}') {
            sr.read();
            return dict;
        }
        List<INode> elts = this.parseKeyValueList(sr);
        sr.skipWhitespace();
        if (!sr.hasMore()) {
            throw new ParseException("missing '}'");
        }
        if (sr.peek() == ',') {
            sr.read();
        }
        if (!sr.hasMore()) {
            throw new ParseException("missing '}'");
        }
        char closechar = sr.read();
        if (closechar != '}') {
            throw new ParseException("expected '}'");
        }
        HashMap<INode, INode> fixedDict = new HashMap<INode, INode>(elts.size());
        for (INode iNode : elts) {
            KeyValueNode kv = (KeyValueNode)iNode;
            fixedDict.put(kv.key, kv.value);
        }
        for (Map.Entry entry : fixedDict.entrySet()) {
            KeyValueNode kvnode = new KeyValueNode();
            kvnode.key = (INode)entry.getKey();
            kvnode.value = (INode)entry.getValue();
            dict.elements.add(kvnode);
        }
        if (dict.elements.size() == 2 && dict.elements.contains(new KeyValueNode(new StringNode("__class__"), new StringNode("float"))) && dict.elements.contains(new KeyValueNode(new StringNode("value"), new StringNode("nan")))) {
            return new DoubleNode(Double.NaN);
        }
        return dict;
    }

    public INode parseSingle(SeekableStringReader sr) {
        sr.skipWhitespace();
        switch (sr.peek()) {
            case 'N': {
                return this.parseNone(sr);
            }
            case 'F': 
            case 'T': {
                return this.parseBool(sr);
            }
            case '\"': 
            case '\'': {
                return this.parseString(sr);
            }
        }
        int bookmark = sr.bookmark();
        try {
            return this.parseComplex(sr);
        }
        catch (ParseException x1) {
            sr.flipBack(bookmark);
            try {
                return this.parseFloat(sr);
            }
            catch (ParseException x2) {
                sr.flipBack(bookmark);
                return this.parseInt(sr);
            }
        }
    }

    INode parseInt(SeekableStringReader sr) {
        String numberstr = sr.readWhile("-0123456789");
        if (numberstr.length() == 0) {
            throw new ParseException("invalid int character");
        }
        try {
            return new IntegerNode(Integer.parseInt(numberstr));
        }
        catch (NumberFormatException x1) {
            try {
                try {
                    return new LongNode(Long.parseLong(numberstr));
                }
                catch (NumberFormatException x2) {
                    try {
                        return new BigIntNode(new BigInteger(numberstr));
                    }
                    catch (NumberFormatException x3) {
                        throw new ParseException("number too large or invalid");
                    }
                }
            }
            catch (NumberFormatException x) {
                throw new ParseException("invalid integer format", x);
            }
        }
    }

    PrimitiveNode<Double> parseFloat(SeekableStringReader sr) {
        String numberstr = sr.readWhile("-+.eE0123456789");
        if (numberstr.length() == 0) {
            throw new ParseException("invalid float character");
        }
        if (numberstr.indexOf(46) < 0 && numberstr.indexOf(101) < 0 && numberstr.indexOf(69) < 0) {
            throw new ParseException("number is not a float (might be an integer though)");
        }
        try {
            return new DoubleNode(Double.parseDouble(numberstr));
        }
        catch (NumberFormatException x) {
            throw new ParseException("invalid float format", x);
        }
    }

    ComplexNumberNode parseComplex(SeekableStringReader sr) {
        if (sr.peek() == '(') {
            double real;
            sr.read();
            String numberstr = sr.peek() == '-' || sr.peek() == '+' ? sr.read(1) + sr.readUntil("+-") : sr.readUntil("+-");
            sr.rewind(1);
            if (numberstr.endsWith("e") || numberstr.endsWith("E")) {
                if (sr.peek() == '-' || sr.peek() == '+') {
                    numberstr = numberstr + sr.read(1);
                }
                numberstr = numberstr + sr.readWhile("0123456789");
            }
            sr.skipWhitespace();
            try {
                real = Double.parseDouble(numberstr);
            }
            catch (NumberFormatException x) {
                throw new ParseException("invalid float format", x);
            }
            double imaginarypart = this.parseImaginaryPart(sr);
            if (sr.read() != ')') {
                throw new ParseException("expected ) to end a complex number");
            }
            ComplexNumberNode c = new ComplexNumberNode();
            c.real = real;
            c.imaginary = imaginarypart;
            return c;
        }
        double imag = this.parseImaginaryPart(sr);
        ComplexNumberNode c = new ComplexNumberNode();
        c.real = 0.0;
        c.imaginary = imag;
        return c;
    }

    double parseImaginaryPart(SeekableStringReader sr) {
        double double_value;
        if (!sr.hasMore()) {
            throw new ParseException("unexpected end of input string");
        }
        char sign_or_digit = sr.peek();
        if (sign_or_digit == '+') {
            sr.read();
        }
        int bookmark = sr.bookmark();
        try {
            PrimitiveNode<Double> float_part = this.parseFloat(sr);
            double_value = (Double)float_part.value;
        }
        catch (ParseException x1) {
            sr.flipBack(bookmark);
            INode integer_part = this.parseInt(sr);
            if (integer_part instanceof IntegerNode) {
                double_value = ((Integer)((IntegerNode)integer_part).value).intValue();
            }
            if (integer_part instanceof LongNode) {
                double_value = ((Long)((LongNode)integer_part).value).longValue();
            }
            if (integer_part instanceof BigIntNode) {
                double_value = ((BigInteger)((BigIntNode)integer_part).value).doubleValue();
            }
            throw new ParseException("not an integer for the imaginary part");
        }
        sr.skipWhitespace();
        try {
            char j_char = sr.read();
            if (j_char != 'j') {
                throw new ParseException("not an imaginary part");
            }
        }
        catch (IndexOutOfBoundsException x) {
            throw new ParseException("not an imaginary part");
        }
        return double_value;
    }

    PrimitiveNode<String> parseString(SeekableStringReader sr) {
        char quotechar = sr.read();
        StringBuilder sb = new StringBuilder(10);
        block12: while (sr.hasMore()) {
            char c = sr.read();
            if (c == '\\') {
                c = sr.read();
                switch (c) {
                    case '\\': {
                        sb.append('\\');
                        continue block12;
                    }
                    case '\'': {
                        sb.append('\'');
                        continue block12;
                    }
                    case '\"': {
                        sb.append('\"');
                        continue block12;
                    }
                    case 'b': {
                        sb.append('\b');
                        continue block12;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block12;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block12;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block12;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block12;
                    }
                    case 'x': {
                        sb.append((char)Integer.parseInt(sr.read(2), 16));
                        continue block12;
                    }
                    case 'u': {
                        sb.append((char)Integer.parseInt(sr.read(4), 16));
                        continue block12;
                    }
                }
                sb.append(c);
                continue;
            }
            if (c == quotechar) {
                return new StringNode(sb.toString());
            }
            sb.append(c);
        }
        throw new ParseException("unclosed string");
    }

    PrimitiveNode<Boolean> parseBool(SeekableStringReader sr) {
        String b = sr.readUntil('e');
        if (b.equals("Tru")) {
            return new BooleanNode(true);
        }
        if (b.equals("Fals")) {
            return new BooleanNode(false);
        }
        throw new ParseException("expected bool, True or False");
    }

    NoneNode parseNone(SeekableStringReader sr) {
        String n = sr.readUntil('e');
        if (n.equals("Non")) {
            return NoneNode.Instance;
        }
        throw new ParseException("expected None");
    }

    public static byte[] toBytes(Object obj) {
        if (obj instanceof Map) {
            Map dict = (Map)obj;
            String data = (String)dict.get("data");
            String encoding = (String)dict.get("encoding");
            if (data == null || encoding == null || !encoding.equals("base64")) {
                throw new IllegalArgumentException("argument is neither bytearray nor serpent base64 encoded bytes dict");
            }
            return Base64.getDecoder().decode(data);
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new IllegalArgumentException("argument is neither bytearray nor serpent base64 encoded bytes dict");
    }
}

