/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jpmml.xgboost.Loadable;

public class XGBoostDataInput
implements Closeable {
    private InputStream is = null;
    private String charset = null;

    public XGBoostDataInput(InputStream is, String charset) {
        this.is = is;
        this.charset = charset;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public int readInt() throws IOException {
        return this.asDataInput().readInt();
    }

    public int[] readIntVector() throws IOException {
        int length = (int)this.readLong();
        return this.readIntArray(length);
    }

    public int[] readIntArray(int length) throws IOException {
        DataInput dataInput = this.asDataInput();
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = dataInput.readInt();
        }
        return result;
    }

    public long readLong() throws IOException {
        return this.asDataInput().readLong();
    }

    public float readFloat() throws IOException {
        return this.asDataInput().readFloat();
    }

    public float[] readFloatVector() throws IOException {
        int length = (int)this.readLong();
        return this.readFloatArray(length);
    }

    public float[] readFloatArray(int length) throws IOException {
        DataInput dataInput = this.asDataInput();
        float[] result = new float[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = dataInput.readFloat();
        }
        return result;
    }

    public String readString() throws IOException {
        int length = (int)this.readLong();
        byte[] buffer = new byte[length];
        ByteStreams.readFully((InputStream)this.is, (byte[])buffer);
        if (this.charset != null) {
            return new String(buffer, this.charset);
        }
        return new String(buffer);
    }

    public String[] readStringVector() throws IOException {
        int length = (int)this.readLong();
        return this.readStringArray(length);
    }

    public String[] readStringArray(int length) throws IOException {
        String[] result = new String[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readString();
        }
        return result;
    }

    public Map<String, String> readStringMap() throws IOException {
        int length = (int)this.readLong();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            result.put(this.readString(), this.readString());
        }
        return result;
    }

    public <E extends Loadable> E[] readObjectVector(Class<? extends E> clazz) throws IOException {
        int length = (int)this.readLong();
        return this.readObjectArray(clazz, length);
    }

    public <E extends Loadable> E[] readObjectArray(Class<? extends E> clazz, int length) throws IOException {
        Loadable[] result = (Loadable[])Array.newInstance(clazz, length);
        for (int i = 0; i < result.length; ++i) {
            Loadable object;
            try {
                object = (Loadable)clazz.newInstance();
            }
            catch (ReflectiveOperationException roe) {
                throw new IOException(roe);
            }
            object.load(this);
            result[i] = object;
        }
        return result;
    }

    public void readReserved(int length) throws IOException {
        int[] buffer = new int[length];
        boolean empty = true;
        for (int i = 0; i < length; ++i) {
            int value;
            buffer[i] = value = this.readInt();
            empty &= value == 0;
        }
        if (!empty) {
            throw new IOException("Expected " + length + "-element array of zeroes, got " + Arrays.toString(buffer));
        }
    }

    private DataInput asDataInput() {
        return (DataInput)((Object)this.is);
    }
}

