/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum JavaVersionUtils {
    JAVA_VERSION;

    public static final int UNKNOWN = -1;
    private int majorVersion;

    private JavaVersionUtils() {
        String javaVersion = System.getProperty("java.version");
        this.majorVersion = this.parseMajor(javaVersion);
    }

    public int getMajor() {
        return this.majorVersion;
    }

    public boolean isKnown() {
        return this.majorVersion != -1;
    }

    public int parseMajor(String version) {
        Pattern p;
        Matcher m;
        boolean b;
        if (version != null && (b = (m = (p = Pattern.compile("1\\.([0-9]*).*|([0-9][0-9]*).*")).matcher(version)).matches())) {
            return Integer.parseInt(m.group(m.group(1) != null ? 1 : 2));
        }
        return -1;
    }

    public boolean useUnifiedLogging() {
        return this.isKnown() && this.getMajor() >= 9;
    }
}

