/*
 * Decompiled with CFR 0.152.
 */
package tpot.builtins;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.TypeUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Classifier;
import sklearn.ClassifierUtil;
import sklearn.Estimator;
import sklearn.HasEstimator;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;

public class StackingEstimator
extends Transformer
implements HasEstimator<Estimator>,
HasNumberOfFeatures {
    public StackingEstimator(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        Estimator estimator = this.getEstimator();
        return estimator.getNumberOfFeatures();
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        ContinuousLabel label;
        Estimator estimator = this.getEstimator();
        MiningFunction miningFunction = estimator.getMiningFunction();
        switch (miningFunction) {
            case CLASSIFICATION: {
                List<?> categories = ClassifierUtil.getClasses(estimator);
                DataType dataType = TypeUtil.getDataType(categories, (DataType)DataType.STRING);
                label = new CategoricalLabel(null, dataType, categories);
                break;
            }
            case REGRESSION: {
                label = new ContinuousLabel(null, DataType.DOUBLE);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Schema schema = new Schema((Label)label, features);
        Model model = estimator.encodeModel(schema);
        encoder.addTransformer(model);
        FieldName name = FieldName.create((String)("stack(" + features.size() + ")"));
        ArrayList<Feature> result = new ArrayList<Feature>();
        switch (miningFunction) {
            case CLASSIFICATION: {
                Classifier classifier = (Classifier)estimator;
                List<?> categories = ClassifierUtil.getClasses(estimator);
                if (classifier.hasProbabilityDistribution()) {
                    for (Object category : categories) {
                        OutputField probabilityOutputField = ModelUtil.createProbabilityField((FieldName)FieldName.create((String)("probability(" + name.getValue() + ", " + category + ")")), (DataType)DataType.DOUBLE, category).setFinalResult(Boolean.valueOf(false));
                        DerivedOutputField probabilityField = encoder.createDerivedField(model, probabilityOutputField, false);
                        result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)probabilityField));
                    }
                }
                OutputField predictedOutputField = ModelUtil.createPredictedField((FieldName)name, (OpType)OpType.CATEGORICAL, (DataType)label.getDataType());
                DerivedOutputField predictedField = encoder.createDerivedField(model, predictedOutputField, false);
                result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, (Field)predictedField, categories));
                break;
            }
            case REGRESSION: {
                OutputField predictedOutputField = ModelUtil.createPredictedField((FieldName)name, (OpType)OpType.CONTINUOUS, (DataType)label.getDataType());
                DerivedOutputField predictedField = encoder.createDerivedField(model, predictedOutputField, false);
                result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)predictedField));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        result.addAll(features);
        return result;
    }

    @Override
    public Estimator getEstimator() {
        return (Estimator)this.get("estimator", Estimator.class);
    }
}

