/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.StringFeature;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public class CastTransformer
extends Transformer {
    public CastTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Object dtype = this.getDType();
        OpType opType = TransformerUtil.getOpType(dtype);
        DataType dataType = TransformerUtil.getDataType(dtype);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            if (!dataType.equals((Object)feature.getDataType())) {
                FieldName name = FeatureUtil.createName((String)dataType.name().toLowerCase(), (Feature)feature);
                FieldRef fieldRef = feature.ref();
                DerivedField derivedField = encoder.ensureDerivedField(name, opType, dataType, () -> fieldRef);
                switch (dataType) {
                    case STRING: {
                        feature = new StringFeature((PMMLEncoder)encoder, (Field)derivedField);
                        break;
                    }
                    case INTEGER: 
                    case FLOAT: 
                    case DOUBLE: {
                        feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
                        break;
                    }
                    default: {
                        feature = new ObjectFeature((PMMLEncoder)encoder, name, dataType);
                    }
                }
            }
            result.add(feature);
        }
        return result;
    }

    public Object getDType() {
        return this.getDType(true);
    }
}

