/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import numpy.DType;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.preprocessing.EncoderUtil;

public class OrdinalEncoder
extends Transformer {
    public OrdinalEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<List<?>> categories = this.getCategories();
        DataType result = null;
        for (int i = 0; i < categories.size(); ++i) {
            List<?> featureCategories = categories.get(i);
            DataType dataType = TypeUtil.getDataType(featureCategories, null);
            if (result == null) {
                result = dataType;
                continue;
            }
            if (result.equals((Object)dataType)) continue;
            throw new UnsupportedOperationException();
        }
        if (result == null) {
            result = DataType.STRING;
        }
        return result;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<List<?>> categories = this.getCategories();
        DType dtype = this.getDType();
        ClassDictUtil.checkSize((Collection[])new Collection[]{categories, features});
        ArrayList<Feature> result = new ArrayList<Feature>();
        DataType dataType = dtype.getDataType();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            List<?> featureCategories = categories.get(i);
            result.add(EncoderUtil.encodeIndexFeature(feature, featureCategories, dataType, encoder));
        }
        return result;
    }

    public List<List<?>> getCategories() {
        return EncoderUtil.transformCategories(this.getList("categories_", HasArray.class));
    }

    public DType getDType() {
        return (DType)this.getDType(false);
    }
}

