/*
 * Decompiled with CFR 0.152.
 */
package sklearn.isotonic;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Regressor;

public class IsotonicRegression
extends Regressor {
    public IsotonicRegression(String module, String name) {
        super(module, name);
    }

    public RegressionModel encodeModel(Schema schema) {
        List<? extends Number> necessaryX = this.getNecessaryX();
        List<? extends Number> necessaryY = this.getNecessaryY();
        String outOfBounds = this.getOutOfBounds();
        ClassDictUtil.checkSize((Collection[])new Collection[]{necessaryX, necessaryY});
        List features = schema.getFeatures();
        SchemaUtil.checkSize((int)1, (List)features);
        Feature feature = (Feature)features.get(0);
        SkLearnEncoder encoder = (SkLearnEncoder)feature.getEncoder();
        OutlierTreatmentMethod outlierTreatment = IsotonicRegression.parseOutlierTreatment(outOfBounds);
        NormContinuous normContinuous = new NormContinuous(feature.getName(), null).setOutliers(outlierTreatment);
        for (int i = 0; i < necessaryX.size(); ++i) {
            Number orig = necessaryX.get(i);
            Number norm = necessaryY.get(i);
            normContinuous.addLinearNorms(new LinearNorm[]{new LinearNorm(orig, norm)});
        }
        DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"isotonicRegression", (Feature)feature), (Expression)normContinuous);
        feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
        return RegressionModelUtil.createRegression(Collections.singletonList(feature), Collections.singletonList(1.0), (Number)0.0, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (Schema)schema);
    }

    public Boolean getIncreasing() {
        return this.getBoolean("increasing_");
    }

    public List<? extends Number> getNecessaryX() {
        return this.getNumberArray("_necessary_X_");
    }

    public List<? extends Number> getNecessaryY() {
        return this.getNumberArray("_necessary_y_");
    }

    public String getOutOfBounds() {
        return this.getString("out_of_bounds");
    }

    public static OutlierTreatmentMethod parseOutlierTreatment(String outOfBounds) {
        switch (outOfBounds) {
            case "nan": {
                return OutlierTreatmentMethod.AS_MISSING_VALUES;
            }
            case "clip": {
                return OutlierTreatmentMethod.AS_EXTREME_VALUES;
            }
        }
        throw new IllegalArgumentException(outOfBounds);
    }
}

