/*
 * Decompiled with CFR 0.152.
 */
package sklearn.impute;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;
import sklearn.impute.ImputerUtil;

public class MissingIndicator
extends Transformer
implements HasNumberOfFeatures {
    public MissingIndicator(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getFeatureIndicesShape();
        return shape[0];
    }

    @Override
    public OpType getOpType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Integer> featureIndices = this.getFeatureIndices();
        Object missingValues = this.getMissingValues();
        if (Double.valueOf(Double.NaN).equals(missingValues)) {
            missingValues = null;
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Integer featureIndex : featureIndices) {
            Feature feature = features.get(featureIndex);
            feature = ImputerUtil.encodeIndicatorFeature(feature, missingValues, encoder);
            result.add(feature);
        }
        return result;
    }

    public List<Integer> getFeatureIndices() {
        return this.getIntegerArray("features_");
    }

    public int[] getFeatureIndicesShape() {
        return this.getArrayShape("features_", 1);
    }

    public Object getMissingValues() {
        return this.getOptionalScalar("missing_values");
    }
}

