/*
 * Decompiled with CFR 0.152.
 */
package sklearn.impute;

import java.util.Collections;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Value;
import org.jpmml.converter.BooleanFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.MissingValueDecorator;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.StringFeature;
import org.jpmml.sklearn.SkLearnEncoder;

public class ImputerUtil {
    private ImputerUtil() {
    }

    public static Feature encodeFeature(Feature feature, Boolean addIndicator, Object missingValue, Object replacementValue, MissingValueTreatmentMethod missingValueTreatmentMethod, SkLearnEncoder encoder) {
        Field field = feature.getField();
        if (field instanceof DataField && !addIndicator.booleanValue()) {
            DataField dataField = (DataField)field;
            encoder.addDecorator(dataField, (Decorator)new MissingValueDecorator(missingValueTreatmentMethod, replacementValue));
            if (missingValue != null) {
                PMMLUtil.addValues((Field)dataField, Collections.singletonList(missingValue), (Value.Property)Value.Property.MISSING);
            }
            return feature;
        }
        if (field instanceof DataField || field instanceof DerivedField) {
            FieldRef expression = feature.ref();
            expression = missingValue != null ? PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)missingValue, (DataType)feature.getDataType())}) : PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{expression});
            expression = PMMLUtil.createApply((String)"if", (Expression[])new Expression[0]).addExpressions(new Expression[]{expression}).addExpressions(new Expression[]{PMMLUtil.createConstant((Object)replacementValue, (DataType)feature.getDataType()), feature.ref()});
            DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"imputer", (Feature)feature), field.getOpType(), field.getDataType(), (Expression)expression);
            DataType dataType = derivedField.getDataType();
            switch (dataType) {
                case INTEGER: 
                case FLOAT: 
                case DOUBLE: {
                    return new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
                }
                case STRING: {
                    return new StringFeature((PMMLEncoder)encoder, (Field)derivedField);
                }
            }
            return new ObjectFeature((PMMLEncoder)encoder, derivedField.getName(), derivedField.getDataType());
        }
        throw new IllegalArgumentException();
    }

    public static Feature encodeIndicatorFeature(Feature feature, Object missingValue, SkLearnEncoder encoder) {
        FieldRef expression = feature.ref();
        expression = missingValue != null ? PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)missingValue, (DataType)feature.getDataType())}) : PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{expression});
        DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"missing_indicator", (Feature)feature), OpType.CATEGORICAL, DataType.BOOLEAN, (Expression)expression);
        return new BooleanFeature((PMMLEncoder)encoder, (Field)derivedField);
    }
}

