/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn.visitors;

import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.visitors.AbstractTreeModelTransformer;

public class TreeModelCompactor
extends AbstractTreeModelTransformer {
    private MiningFunction miningFunction = null;

    public void enterNode(Node node) {
        Object id = node.getId();
        Object score = node.getScore();
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (node.hasNodes()) {
            List children = node.getNodes();
            if (children.size() != 2) {
                throw new IllegalArgumentException();
            }
            Node firstChild = (Node)children.get(0);
            Node secondChild = (Node)children.get(1);
            Predicate firstPredicate = firstChild.getPredicate();
            Predicate secondPredicate = secondChild.getPredicate();
            TreeModelCompactor.checkFieldReference((Predicate)firstPredicate, (Predicate)secondPredicate);
            TreeModelCompactor.checkValue((Predicate)firstPredicate, (Predicate)secondPredicate);
            if (TreeModelCompactor.hasOperator((Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.NOT_EQUAL) && TreeModelCompactor.hasOperator((Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL)) {
                children = TreeModelCompactor.swapChildren((Node)node);
                firstChild = (Node)children.get(0);
                secondChild = (Node)children.get(1);
            } else if (!TreeModelCompactor.hasOperator((Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.LESS_OR_EQUAL) || !TreeModelCompactor.hasOperator((Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.GREATER_THAN)) {
                throw new IllegalArgumentException();
            }
            secondChild.setPredicate((Predicate)True.INSTANCE);
        } else if (score == null) {
            throw new IllegalArgumentException();
        }
        node.setId(null);
    }

    public void exitNode(Node node) {
        Predicate predicate = node.getPredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            if (MiningFunction.REGRESSION.equals((Object)this.miningFunction)) {
                parentNode.setScore(null);
                TreeModelCompactor.initScore((Node)parentNode, (Node)node);
                TreeModelCompactor.replaceChildWithGrandchildren((Node)parentNode, (Node)node);
            } else if (MiningFunction.CLASSIFICATION.equals((Object)this.miningFunction)) {
                if (node.hasNodes()) {
                    TreeModelCompactor.replaceChildWithGrandchildren((Node)parentNode, (Node)node);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void enterTreeModel(TreeModel treeModel) {
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        TreeModel.SplitCharacteristic splitCharacteristic = treeModel.getSplitCharacteristic();
        if (!(TreeModel.MissingValueStrategy.NONE.equals((Object)missingValueStrategy) && TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION.equals((Object)noTrueChildStrategy) && TreeModel.SplitCharacteristic.BINARY_SPLIT.equals((Object)splitCharacteristic))) {
            throw new IllegalArgumentException();
        }
        this.miningFunction = treeModel.getMiningFunction();
    }

    public void exitTreeModel(TreeModel treeModel) {
        treeModel.setMissingValueStrategy(TreeModel.MissingValueStrategy.NULL_PREDICTION).setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
        switch (this.miningFunction) {
            case REGRESSION: {
                treeModel.setNoTrueChildStrategy(TreeModel.NoTrueChildStrategy.RETURN_LAST_PREDICTION);
                break;
            }
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.miningFunction = null;
    }
}

