/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.CategoryEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.core.Index;
import pandas.core.Series;
import pandas.core.SingleBlockManager;
import sklearn.preprocessing.EncoderUtil;

public class OrdinalEncoder
extends CategoryEncoder {
    public OrdinalEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Boolean dropInvariant = this.getDropInvariant();
        String handleMissing = this.getHandleMissing();
        String handleUnknown = this.getHandleUnknown();
        List<CategoryEncoder.Mapping> mappings = this.getMapping();
        if (dropInvariant.booleanValue()) {
            throw new IllegalArgumentException();
        }
        ClassDictUtil.checkSize((Collection[])new Collection[]{mappings, features});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            CategoryEncoder.Mapping mapping = mappings.get(i);
            Map<Object, Integer> categoryMappings = OrdinalEncoder.getCategoryMapping(mapping);
            List<Object> categories = new ArrayList<Object>();
            categories.addAll(categoryMappings.keySet());
            List<Integer> indices = new ArrayList<Integer>();
            indices.addAll(categoryMappings.values());
            Integer mapMissingTo = null;
            switch (handleMissing) {
                case "value": {
                    Number lastCategory = (Number)categories.get(categories.size() - 1);
                    if (!Double.isNaN(lastCategory.doubleValue())) {
                        throw new IllegalArgumentException(String.valueOf(lastCategory));
                    }
                    Integer lastIndex = (Integer)indices.get(indices.size() - 1);
                    if (lastIndex != -2) {
                        throw new IllegalArgumentException(String.valueOf(lastIndex));
                    }
                    categories = categories.subList(0, categories.size() - 1);
                    indices = indices.subList(0, indices.size() - 1);
                    mapMissingTo = -2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(handleMissing);
                }
            }
            Integer defaultValue = null;
            switch (handleUnknown) {
                case "value": {
                    defaultValue = -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(handleUnknown);
                }
            }
            result.add(EncoderUtil.encodeIndexFeature(feature, categories, indices, mapMissingTo, defaultValue, DataType.INTEGER, encoder));
        }
        return result;
    }

    public static Map<Object, Integer> getCategoryMapping(CategoryEncoder.Mapping mapping) {
        SingleBlockManager mappingData = mapping.getMapping(Series.class).getData();
        Index blockItem = mappingData.getOnlyBlockItem();
        List categories = blockItem.getData().getData();
        HasArray blockValue = mappingData.getOnlyBlockValue();
        List indices = ValueUtil.asIntegers((List)blockValue.getArrayContent());
        ClassDictUtil.checkSize((Collection[])new Collection[]{categories, indices});
        LinkedHashMap<Object, Integer> result = new LinkedHashMap<Object, Integer>();
        for (int i = 0; i < categories.size(); ++i) {
            result.put(categories.get(i), (Integer)indices.get(i));
        }
        return result;
    }
}

