/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.BaseNFeature;
import category_encoders.CategoryEncoder;
import category_encoders.OrdinalEncoder;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;

public class BaseNEncoder
extends CategoryEncoder {
    public BaseNEncoder(String module, String name) {
        super(module, name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Integer base = this.getBase();
        List<String> dropCols = null;
        Boolean dropInvariant = this.getDropInvariant();
        OrdinalEncoder ordinalEncoder = this.getOrdinalEncoder();
        String handleMissing = this.getHandleMissing();
        String handleUnknown = this.getHandleUnknown();
        List<CategoryEncoder.Mapping> mappings = this.getMapping();
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException(Integer.toString(base));
        }
        if (dropInvariant.booleanValue()) {
            dropCols = this.getDropCols();
        }
        switch (handleMissing) {
            case "value": {
                break;
            }
            default: {
                throw new IllegalArgumentException(handleMissing);
            }
        }
        switch (handleUnknown) {
            case "value": {
                break;
            }
            default: {
                throw new IllegalArgumentException(handleUnknown);
            }
        }
        List<CategoryEncoder.Mapping> ordinalMappings = ordinalEncoder.getMapping();
        ClassDictUtil.checkSize((Collection[])new Collection[]{mappings, ordinalMappings, features});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            CategoryEncoder.Mapping mapping = mappings.get(i);
            CategoryEncoder.Mapping ordinalMapping = ordinalMappings.get(i);
            Map<Object, Integer> ordinalCategoryMappings = OrdinalEncoder.getCategoryMapping(ordinalMapping);
            ordinalCategoryMappings.remove(CategoryEncoder.CATEGORY_MISSING);
            int requiredDigits = BaseNEncoder.calcRequiredDigits(ordinalCategoryMappings, base);
            Map<Object, String> baseCategoryMappings = BaseNEncoder.baseEncodeValues(ordinalCategoryMappings, base, requiredDigits);
            ArrayList<void> baseFeatures = new ArrayList<void>();
            for (int pos = 0; pos < requiredDigits; ++pos) {
                void var25_26;
                String col = String.valueOf(i) + "_" + String.valueOf(pos);
                if (dropCols != null && dropCols.contains(col)) continue;
                LinkedHashMultimap values = LinkedHashMultimap.create();
                Set<Map.Entry<Object, String>> entries = baseCategoryMappings.entrySet();
                for (Map.Entry entry : entries) {
                    Object category = entry.getKey();
                    String baseValue = (String)entry.getValue();
                    char digit = baseValue.charAt(pos);
                    if (digit == '0') continue;
                    values.put((Object)Character.getNumericValue(digit), category);
                }
                final FieldName derivedName = FeatureUtil.createName((String)("base" + base), (Feature)feature, (int)pos);
                BaseNFeature baseNFeature = new BaseNFeature((PMMLEncoder)encoder, feature, base, (SetMultimap)values){

                    public FieldName getDerivedName() {
                        return derivedName;
                    }
                };
                if (base == 2) {
                    ContinuousFeature continuousFeature = baseNFeature.toContinuousFeature();
                    DerivedField derivedField = (DerivedField)encoder.getField(continuousFeature.getName());
                    derivedField.setOpType(OpType.CATEGORICAL);
                    BinaryFeature binaryFeature = new BinaryFeature((PMMLEncoder)encoder, (Field)derivedField, (Object)1);
                }
                baseFeatures.add(var25_26);
            }
            result.addAll(baseFeatures);
        }
        return result;
    }

    public Integer getBase() {
        return this.getInteger("base");
    }

    public OrdinalEncoder getOrdinalEncoder() {
        return (OrdinalEncoder)this.get("ordinal_encoder", OrdinalEncoder.class);
    }

    private static int calcRequiredDigits(Map<?, Integer> ordinalCategoryMappings, int base) {
        if (base == 1) {
            return ordinalCategoryMappings.size() + 1;
        }
        return (int)Math.ceil(Math.log(ordinalCategoryMappings.size()) / Math.log(base)) + 1;
    }

    public static Map<Object, String> baseEncodeValues(Map<Object, Integer> categoryMappings, int base, int requiredDigits) {
        LinkedHashMap<Object, String> result = new LinkedHashMap<Object, String>();
        Set<Map.Entry<Object, Integer>> entries = categoryMappings.entrySet();
        for (Map.Entry entry : entries) {
            String baseValue = Strings.padStart((String)Integer.toString((Integer)entry.getValue(), base), (int)requiredDigits, (char)'0');
            result.put(entry.getKey(), baseValue);
        }
        return result;
    }
}

