/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExpression;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.converter.visitors.FieldUtil;
import org.jpmml.model.visitors.FieldReferenceFinder;
import org.jpmml.model.visitors.FieldResolver;

public class FieldDependencyResolver
extends FieldResolver {
    private Map<Field<?>, Set<Field<?>>> dependencies = new IdentityHashMap();
    private Set<DataField> dataFields = new HashSet<DataField>();
    private Set<DerivedField> globalDerivedFields = new HashSet<DerivedField>();
    private Set<DerivedField> localDerivedFields = new HashSet<DerivedField>();
    private Set<OutputField> outputFields = new HashSet<OutputField>();
    public static int MAX_STACK_HEIGHT = 50;

    public void reset() {
        super.reset();
        this.dependencies.clear();
        this.dataFields.clear();
        this.globalDerivedFields.clear();
        this.localDerivedFields.clear();
        this.outputFields.clear();
    }

    public VisitorAction visit(DataDictionary dataDictionary) {
        if (dataDictionary.hasDataFields()) {
            this.dataFields.addAll(dataDictionary.getDataFields());
        }
        return super.visit(dataDictionary);
    }

    public VisitorAction visit(DataField dataField) {
        this.process((Field<?>)dataField);
        return super.visit(dataField);
    }

    public VisitorAction visit(DerivedField derivedField) {
        PMMLObject parent = this.getParent();
        if (parent instanceof TransformationDictionary || parent instanceof LocalTransformations) {
            this.process((Field<?>)derivedField);
        }
        return super.visit(derivedField);
    }

    public VisitorAction visit(LocalTransformations localTransformations) {
        if (localTransformations.hasDerivedFields()) {
            this.localDerivedFields.addAll(localTransformations.getDerivedFields());
        }
        return super.visit(localTransformations);
    }

    public VisitorAction visit(Output output) {
        if (output.hasOutputFields()) {
            this.outputFields.addAll(output.getOutputFields());
        }
        return super.visit(output);
    }

    public VisitorAction visit(OutputField outputField) {
        this.process((Field<?>)outputField);
        return super.visit(outputField);
    }

    public VisitorAction visit(TransformationDictionary transformationDictionary) {
        if (transformationDictionary.hasDerivedFields()) {
            this.globalDerivedFields.addAll(transformationDictionary.getDerivedFields());
        }
        return super.visit(transformationDictionary);
    }

    public Set<Field<?>> getDependencies(Field<?> field) {
        Map<Field<?>, Set<Field<?>>> dependencies = this.getDependencies();
        if (!dependencies.containsKey(field)) {
            throw new IllegalArgumentException();
        }
        return dependencies.get(field);
    }

    public Map<Field<?>, Set<Field<?>>> getDependencies() {
        return this.dependencies;
    }

    Set<DataField> getDataFields() {
        return this.dataFields;
    }

    Set<DerivedField> getGlobalDerivedFields() {
        return this.globalDerivedFields;
    }

    Set<DerivedField> getLocalDerivedFields() {
        return this.localDerivedFields;
    }

    Set<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public Set<Field<?>> expand(Set<Field<?>> fields, Set<? extends Field<?>> expandableFields) {
        LinkedHashSet removableFields = new LinkedHashSet();
        LinkedHashSet expandedFields = new LinkedHashSet();
        int i = 0;
        while (true) {
            if (i > MAX_STACK_HEIGHT) {
                throw new IllegalStateException();
            }
            removableFields.clear();
            for (Field field : fields) {
                if (!expandableFields.contains(field)) continue;
                removableFields.add(field);
            }
            if (removableFields.isEmpty()) break;
            for (Field field : removableFields) {
                Set<Field<?>> dependencies = this.getDependencies(field);
                fields.addAll(dependencies);
            }
            fields.removeAll(removableFields);
            expandedFields.addAll(removableFields);
            ++i;
        }
        return expandedFields;
    }

    private void process(Field<?> field) {
        HasExpression hasExpression;
        Expression expression;
        Set activeFields = Collections.emptySet();
        if (field instanceof HasExpression && (expression = (hasExpression = (HasExpression)field).getExpression()) != null) {
            FieldReferenceFinder fieldReferenceFinder = new FieldReferenceFinder();
            fieldReferenceFinder.applyTo((Visitable)expression);
            Set names = fieldReferenceFinder.getFieldNames();
            if (names.size() > 0) {
                Collection fields = this.getFields();
                activeFields = new LinkedHashSet(2 * names.size());
                activeFields.addAll(FieldUtil.selectAll(fields, names));
            }
        }
        this.dependencies.put(field, activeFields);
    }
}

