/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;

public class H2OEncoder
extends ModelEncoder {
    private Label label = null;
    private List<Feature> features = new ArrayList<Feature>();

    public DataField createDataField(FieldName name, String[] categories) {
        if (categories != null) {
            return this.createDataField(name, OpType.CATEGORICAL, DataType.STRING, Arrays.asList(categories));
        }
        return this.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
    }

    public Schema createSchema() {
        return new Schema(this.getLabel(), this.getFeatures());
    }

    public void setLabel(DataField dataField) {
        OpType opType = dataField.getOpType();
        switch (opType) {
            case CONTINUOUS: {
                this.setLabel((Label)new ContinuousLabel(dataField));
                break;
            }
            case CATEGORICAL: {
                this.setLabel((Label)new CategoricalLabel(dataField));
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected categorical or continuous operational type, got " + opType.value() + " operational type");
            }
        }
    }

    public void addFeature(DataField dataField) {
        OpType opType = dataField.getOpType();
        switch (opType) {
            case CONTINUOUS: {
                this.addFeature((Feature)new ContinuousFeature((PMMLEncoder)this, (Field)dataField));
                break;
            }
            case CATEGORICAL: {
                this.addFeature((Feature)new CategoricalFeature((PMMLEncoder)this, dataField));
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected categorical or continuous operational type, got " + opType.value() + " operational type");
            }
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void addFeature(Feature feature) {
        this.features.add(feature);
    }
}

